/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsAnlagenchrono;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsAnlagenchrono
extends AbstractVawsAnlagenchrono
implements Serializable {
    public VawsAnlagenchrono() {
    }

    public VawsAnlagenchrono(Integer id) {
        super(id);
    }

    public static List getAnlagenChrono(VawsFachdaten fachdaten) {
        List chrono;
        if (fachdaten.getBehaelterId() == null) {
            chrono = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                chrono = session.createQuery("from VawsAnlagenchrono as vac where vac.vawsFachdaten = ? order by vac.datum, vac.wv").setEntity(0, (Object)fachdaten).list();
                AUIKataster.debugOutput(chrono.size() + " AChrono-Eintr\u00e4ge f\u00fcr FD " + fachdaten + " gefunden!", "VawsAnlagenchrono");
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return chrono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAnlagenChrono(VawsAnlagenchrono chrono) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)chrono);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsAnlagenchrono.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeAnlagenChrono(VawsAnlagenchrono chrono) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)chrono);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsAnlagenchrono.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

