/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsAbscheider;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsAbscheider
extends AbstractVawsAbscheider
implements Serializable {
    public VawsAbscheider() {
    }

    public VawsAbscheider(Integer id) {
        super(id);
    }

    public String toString() {
        return "[VawsAbscheider: " + this.getBehaelterid() + ", FD:" + this.getVawsFachdaten() + "]";
    }

    public static VawsAbscheider getAbscheider(VawsFachdaten fachdaten) {
        VawsAbscheider abscheider;
        List tmp;
        if (fachdaten == null || !fachdaten.getAnlagenart().equals("VAwS-Abscheider")) {
            throw new IllegalArgumentException("Fachdaten-Objekt ist kein VAwS-Abscheider!");
        }
        if (fachdaten.getBehaelterId() == null) {
            tmp = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                tmp = session.createQuery("from VawsAbscheider abff where abff.vawsFachdaten = ? ").setEntity(0, (Object)fachdaten).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        if (tmp.size() > 0) {
            abscheider = (VawsAbscheider)tmp.get(0);
            AUIKataster.debugOutput("Fl\u00e4che '" + abscheider + "' geladen!", "VawsAbscheider.getAbscheider()");
        } else {
            abscheider = new VawsAbscheider();
            abscheider.setVawsFachdaten(fachdaten);
            AUIKataster.debugOutput("Neuer Abscheider f\u00fcr '" + fachdaten + "' erzeugt!", "VawsAbscheider.getAbscheider()");
        }
        return abscheider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAbscheider(VawsAbscheider abscheider) {
        boolean saved;
        if (abscheider.getVawsFachdaten() == null) {
            throw new IllegalArgumentException("Die VawsAbscheider muss einem VawsFachdaten-Objekt zugeordnet sein!");
        }
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)abscheider);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsAbscheider.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }
}

