/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsAbfuellflaeche;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsAbfuellflaeche
extends AbstractVawsAbfuellflaeche
implements Serializable {
    private static short fW = 0;
    private static short tW = (short)-1;
    public static Short FALSE = new Short(fW);
    public static Short TRUE = new Short(tW);

    public VawsAbfuellflaeche() {
    }

    public VawsAbfuellflaeche(Integer id) {
        super(id);
    }

    public String toString() {
        return "[VawsAbfuellflaeche: " + this.getBehaelterid() + ", FD:" + this.getVawsFachdaten() + "]";
    }

    public static VawsAbfuellflaeche getAbfuellflaeche(VawsFachdaten fachdaten) {
        VawsAbfuellflaeche flaeche;
        List tmp;
        if (fachdaten == null || !fachdaten.getAnlagenart().equals("Abf\u00fcllfl\u00e4che")) {
            throw new IllegalArgumentException("Fachdaten-Objekt ist keine Abf\u00fcllfl\u00e4che!");
        }
        if (fachdaten.getBehaelterId() == null) {
            tmp = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                tmp = session.createQuery("from VawsAbfuellflaeche abff where abff.vawsFachdaten = ? ").setEntity(0, (Object)fachdaten).list();
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        if (tmp.size() > 0) {
            flaeche = (VawsAbfuellflaeche)tmp.get(0);
            AUIKataster.debugOutput("Fl\u00e4che '" + flaeche + "' geladen!", "VawsAbfuellflaeche.getAbfuellflaeche()");
        } else {
            flaeche = new VawsAbfuellflaeche();
            flaeche.setVawsFachdaten(fachdaten);
            AUIKataster.debugOutput("Neue Fl\u00e4che f\u00fcr '" + fachdaten + "' erzeugt!", "VawsAbfuellflaeche.getAbfuellflaeche()");
        }
        return flaeche;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAbfuellflaeche(VawsAbfuellflaeche flaeche) {
        boolean saved;
        if (flaeche.getVawsFachdaten() == null) {
            throw new IllegalArgumentException("Die VawsAbfuellflaeche muss einem VawsFachdaten-Objekt zugeordnet sein!");
        }
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)flaeche);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsAbfuellflaeche.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static String[] getBodenflaechenausfArray() {
        String[] tmp;
        String suchString = "select distinct vabf.bodenflaechenausf from VawsAbfuellflaeche vabf order by vabf.bodenflaechenausf";
        try {
            Session session = HibernateSessionFactory.currentSession();
            Query query = session.createQuery(suchString);
            query.setCacheable(true);
            query.setCacheRegion("vawsabausfliste");
            List list = query.list();
            tmp = new String[list.size()];
            tmp = list.toArray(tmp);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    public static String[] getNiederschlagschutzArray() {
        String[] tmp;
        String suchString = "select distinct vabf.niederschlagschutz from VawsAbfuellflaeche vabf order by vabf.niederschlagschutz";
        try {
            Session session = HibernateSessionFactory.currentSession();
            Query query = session.createQuery(suchString);
            query.setCacheable(true);
            query.setCacheRegion("vawsabnieliste");
            List list = query.list();
            tmp = new String[list.size()];
            tmp = list.toArray(tmp);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }
}

