/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractIndeinlUebergabestelle;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class IndeinlUebergabestelle
extends AbstractIndeinlUebergabestelle
implements Serializable {
    public IndeinlUebergabestelle() {
    }

    public IndeinlUebergabestelle(Integer objektid) {
        super(objektid);
    }

    public String toString() {
        return "[Uebergabestelle:" + this.getObjektid() + "]";
    }

    private static IndeinlUebergabestelle getUebergabeByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List stelle;
        IndeinlUebergabestelle fachdaten = null;
        if (objekt.getBasisObjektarten().isUebergabestelle() && (stelle = session.createQuery("from IndeinlUebergabestelle as stelle where stelle.basisObjekt = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            fachdaten = (IndeinlUebergabestelle)stelle.get(0);
        }
        return fachdaten;
    }

    public static IndeinlUebergabestelle getUebergabeByObjekt(BasisObjekt objekt) {
        IndeinlUebergabestelle fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = IndeinlUebergabestelle.getUebergabeByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(IndeinlUebergabestelle fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "SuevFachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List getAuswertungsListe() {
        List liste;
        String query = "from IndeinlUebergabestelle as stelle order by stelle.objektid";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

