/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractIndeinlGenehmigung;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class IndeinlGenehmigung
extends AbstractIndeinlGenehmigung
implements Serializable {
    public IndeinlGenehmigung() {
    }

    public IndeinlGenehmigung(Integer objektid) {
        super(objektid);
    }

    public String toString() {
        return "[Genehmigung Verfahren:" + this.getObjektid() + "]";
    }

    private static IndeinlGenehmigung getGenByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List gen;
        IndeinlGenehmigung fachdaten = null;
        if (objekt.getBasisObjektarten().isGenehmigung() && (gen = session.createQuery("from IndeinlGenehmigung as gen where gen.basisObjekt = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            fachdaten = (IndeinlGenehmigung)gen.get(0);
        }
        return fachdaten;
    }

    public static IndeinlGenehmigung getGenByObjekt(BasisObjekt objekt) {
        IndeinlGenehmigung fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = IndeinlGenehmigung.getGenByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(IndeinlGenehmigung fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "GenFachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List getAuswertungsListe(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.gen58 = ? or gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    public static List getAnh40Liste(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.anhang = 40 and gen.gen58 = ? or gen.anhang = 40 and gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    public static List getAnh49Liste(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.anhang = 49 and gen.gen58 = ? or gen.anhang = 49 and gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    public static List getAnh50Liste(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.anhang = 50 and gen.gen58 = ? or gen.anhang = 50 and gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    public static List getAnh53Liste(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.anhang = 53 and gen.gen58 = ? or gen.anhang = 53 and gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisBetreiber.betrname";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    public static List getBwkListe(Boolean gen58, Boolean gen59) {
        List liste;
        String query = "from IndeinlGenehmigung as gen where gen.anhang Is Null and gen.gen58 = ? or gen.anhang Is Null and gen.gen59 = ? order by gen.basisObjekt.inaktiv, gen.basisObjekt.basisStandort.strasse, gen.basisObjekt.basisStandort.hausnr";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).setBoolean(0, gen58.booleanValue()).setBoolean(1, gen59.booleanValue()).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

