/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnhSuevFachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AnhSuevFachdaten
extends AbstractAnhSuevFachdaten
implements Serializable {
    public AnhSuevFachdaten() {
    }

    public AnhSuevFachdaten(Integer suevid) {
        super(suevid);
    }

    public String toString() {
        return "[SuevKan Verfahren:" + this.getObjektid() + "]";
    }

    private static AnhSuevFachdaten getSuevByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List suev;
        AnhSuevFachdaten fachdaten = null;
        if (objekt.getBasisObjektarten().isSuev() && (suev = session.createQuery("from AnhSuevFachdaten as suev where suev.basisObjekt = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            fachdaten = (AnhSuevFachdaten)suev.get(0);
        }
        return fachdaten;
    }

    public static AnhSuevFachdaten getSuevByObjekt(BasisObjekt objekt) {
        AnhSuevFachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = AnhSuevFachdaten.getSuevByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(AnhSuevFachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "SuevFachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List getAuswertungsListe() {
        List liste;
        String query = "from AnhSuevFachdaten as sv order by sv.basisObjekt.inaktiv, sv.objektid";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

