/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnhBwkFachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AnhBwkFachdaten
extends AbstractAnhBwkFachdaten
implements Serializable {
    public AnhBwkFachdaten() {
    }

    public AnhBwkFachdaten(Integer bwkId) {
        super(bwkId);
    }

    public String toString() {
        return "[BWK:" + this.getBwkId() + "," + this.getKHersteller() + " " + this.getKTyp() + "]";
    }

    private static AnhBwkFachdaten getAnhBwkByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List brennwert;
        AnhBwkFachdaten bwk = null;
        if (objekt.getBasisObjektarten().isBWK() && (brennwert = session.createQuery("from AnhBwkFachdaten as brennwert where brennwert.basisObjekt = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            bwk = (AnhBwkFachdaten)brennwert.get(0);
        }
        return bwk;
    }

    public static AnhBwkFachdaten getAnhBwkByObjekt(BasisObjekt objekt) {
        AnhBwkFachdaten bwk2;
        try {
            Session session = HibernateSessionFactory.currentSession();
            bwk2 = AnhBwkFachdaten.getAnhBwkByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            Object bwk2 = null;
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        return bwk2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBwk(AnhBwkFachdaten bwk) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)bwk);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "AnhBwk.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List findByErfassungsjahr(int jahr) {
        List liste;
        String query = "from AnhBwkFachdaten as bwk ";
        if (jahr != -1) {
            if (jahr > 0 && jahr < 100) {
                jahr = jahr <= 30 ? (jahr += 2000) : (jahr += 1900);
            }
            query = query + "where bwk.erfassung = ? ";
        }
        query = query + "order by bwk.basisObjekt.inaktiv, bwk.erfassung, bwk.basisObjekt.basisBetreiber.betrname, bwk.basisObjekt.basisBetreiber.betrnamezus, bwk.basisObjekt.basisStandort.strasse, bwk.basisObjekt.basisStandort.hausnr";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = jahr != -1 ? session.createQuery(query).setInteger(0, jahr).list() : session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

