/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh55Fachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh55Fachdaten
extends AbstractAnh55Fachdaten
implements Serializable {
    public Anh55Fachdaten() {
    }

    public Anh55Fachdaten(Integer id) {
        super(id);
    }

    public String toString() {
        return "[ID:" + this.getId() + "]";
    }

    public static Anh55Fachdaten getAnh55ByObjekt(BasisObjekt objekt, Session session) {
        Anh55Fachdaten fachdaten = null;
        if (objekt.getBasisObjektarten().isAnh55()) {
            try {
                List anhang55 = session.createQuery("from Anh55Fachdaten as anhang55 where anhang55.basisObjekt = ?").setEntity(0, (Object)objekt).list();
                if (anhang55.size() > 0) {
                    fachdaten = (Anh55Fachdaten)anhang55.get(0);
                }
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
        }
        return fachdaten;
    }

    public static Anh55Fachdaten getAnh55ByObjekt(BasisObjekt objekt) {
        Anh55Fachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = Anh55Fachdaten.getAnh55ByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(Anh55Fachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh55Fachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List getAuswertungsListe() {
        List liste;
        String query = "from Anh55Fachdaten as anh55 order by anh55.basisObjekt.inaktiv, anh55.id";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

