/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh53Fachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh53Fachdaten
extends AbstractAnh53Fachdaten
implements Serializable {
    public Anh53Fachdaten() {
    }

    public Anh53Fachdaten(Integer objektid) {
        super(objektid);
    }

    public String toString() {
        return "[ID:" + this.getObjektid() + "]";
    }

    public static Anh53Fachdaten getAnh53ByObjekt(BasisObjekt objekt, Session session) {
        Anh53Fachdaten fachdaten = null;
        if (objekt.getBasisObjektarten().isAnh53Gr() || objekt.getBasisObjektarten().isAnh53Kl()) {
            try {
                List anhang53 = session.createQuery("from Anh53Fachdaten as anhang53 where anhang53.basisObjekt = ?").setEntity(0, (Object)objekt).list();
                if (anhang53.size() > 0) {
                    fachdaten = (Anh53Fachdaten)anhang53.get(0);
                }
            }
            catch (HibernateException hibernateException) {
                // empty catch block
            }
        }
        return fachdaten;
    }

    public static Anh53Fachdaten getAnh53ByObjekt(BasisObjekt objekt) {
        Anh53Fachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = Anh53Fachdaten.getAnh53ByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(Anh53Fachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh53Fachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List getAuswertungsListe() {
        List liste;
        String query = "from Anh53Fachdaten as anh53 order by anh53.basisObjekt.inaktiv, anh53.basisObjekt.basisObjektarten.objektartid, anh53.basisObjekt.basisStandort.strasse, anh53.basisObjekt.basisStandort.hausnr";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }
}

