/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh50Fachdaten;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh50Fachdaten
extends AbstractAnh50Fachdaten
implements Serializable {
    public Anh50Fachdaten() {
    }

    public Anh50Fachdaten(Integer firmenid) {
        super(firmenid);
    }

    public String toString() {
        return "[ID:" + this.getObjektid() + "]";
    }

    public static List findByWiedervorlage(boolean nurWiedervorlageAbgelaufen) {
        List anhang50;
        try {
            Session session = HibernateSessionFactory.currentSession();
            if (nurWiedervorlageAbgelaufen) {
                Date today = new Date();
                anhang50 = session.createQuery("from Anh50Fachdaten as anh50 where anh50.wiedervorlage <= ? and anh50.erloschen = 'f' order by anh50.basisObjekt.inaktiv, anh50.wiedervorlage, anh50.basisObjekt.basisBetreiber.betrname").setDate(0, today).list();
            } else {
                anhang50 = session.createQuery("from Anh50Fachdaten as anh50 where anh50.erloschen = 'f' order by anh50.basisObjekt.inaktiv, anh50.wiedervorlage, anh50.basisObjekt.basisBetreiber.betrname").list();
            }
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return anhang50;
    }

    private static Anh50Fachdaten getAnh50ByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List anhang50;
        Anh50Fachdaten fachdaten = null;
        Integer objID = objekt.getObjektid();
        if (objekt.getBasisObjektarten().isAnh50() && (anhang50 = session.createQuery("from Anh50Fachdaten as anhang50 where anhang50.objektid = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            fachdaten = (Anh50Fachdaten)anhang50.get(0);
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anh50Fachdaten getAnh50ByObjekt(BasisObjekt objekt) {
        Anh50Fachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = Anh50Fachdaten.getAnh50ByObjekt(objekt, session);
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(Anh50Fachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh50Fachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }
}

