/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh49Ortstermine;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh49Ortstermine
extends AbstractAnh49Ortstermine
implements Serializable {
    public Anh49Ortstermine() {
    }

    public Anh49Ortstermine(Integer ortsterminid) {
        super(ortsterminid);
    }

    public String toString() {
        return "[Datum: " + AuikUtils.getStringFromDate(this.getDatum()) + ", SachbearbeiterIn: " + this.getSachbearbeiterIn() + "]";
    }

    public static List getOrtstermine(Anh49Fachdaten fd) {
        List ot;
        try {
            Session session = HibernateSessionFactory.currentSession();
            ot = session.createQuery("from Anh49Ortstermine as ot where ot.anh49Fachdaten = ? order by ot.datum").setEntity(0, (Object)fd).list();
            AUIKataster.debugOutput("Ortstermine f\u00fcr " + fd + ", Anzahl: " + ot.size(), "Anh49Ortstermine");
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return ot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOrUpdateOrtstermin(Anh49Ortstermine ot) {
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)ot);
                tx.commit();
            }
            catch (HibernateException e) {
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (Anh49Ortstermine)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeOrtstermin(Anh49Ortstermine ot) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)ot);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh49Ortstermin.objectRemoved", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

