/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh49Fachdaten;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh49Fachdaten
extends AbstractAnh49Fachdaten
implements Serializable {
    public String toString() {
        String tmp = "[Anh49:" + this.getBasisObjekt() + "]";
        return tmp;
    }

    public static List findAlle() {
        String query = "from Anh49Fachdaten anh49 where anh49.basisObjekt.basisObjektarten.objektart not like 'Fettabscheider' order by anh49.basisObjekt.inaktiv, anh49.sachbearbeiterIn";
        Session session = HibernateSessionFactory.currentSession();
        List anhang49 = session.createQuery(query).list();
        HibernateSessionFactory.closeSession();
        return anhang49;
    }

    public static List findAuswertung(Boolean abgemeldet, String abgerissen, Boolean abwasserfrei, boolean nurWiedervorlageAbgelaufen) {
        List anhang49;
        Date today = new Date();
        String abgr = abgerissen.toLowerCase().trim() + "%";
        String query = "from Anh49Fachdaten ah49 where ah49.abgemeldet = ? and lower(ah49.sonstigestechnik) like ? and ah49.abwasserfrei = ? and ah49.basisObjekt.basisObjektarten.objektart not like 'Fettabscheider' ";
        if (nurWiedervorlageAbgelaufen) {
            query = query + "and ah49.wiedervorlage <= ? order by ah49.basisObjekt.inaktiv, ah49.wiedervorlage, ah49.basisObjekt.basisBetreiber.betrname";
            Session session = HibernateSessionFactory.currentSession();
            anhang49 = session.createQuery(query).setString(0, abgemeldet != false ? "t" : "f").setString(1, abgr).setString(2, abwasserfrei != false ? "t" : "f").setDate(3, today).list();
            HibernateSessionFactory.closeSession();
        } else {
            query = query + "order by ah49.basisObjekt.inaktiv, ah49.wiedervorlage, ah49.basisObjekt.basisBetreiber.betrname";
            Session session = HibernateSessionFactory.currentSession();
            anhang49 = session.createQuery(query).setString(0, abgemeldet != false ? "t" : "f").setString(1, abgr).setString(2, abwasserfrei != false ? "t" : "f").list();
            HibernateSessionFactory.closeSession();
        }
        return anhang49;
    }

    public static Anh49Fachdaten getAnh49ByObjekt(BasisObjekt objekt, Session session) {
        Anh49Fachdaten fachdaten = null;
        Integer objID = objekt.getObjektid();
        if (objekt.getBasisObjektarten().isAnh49()) {
            try {
                List anhang49 = session.createQuery("from Anh49Fachdaten as ah49 where ah49.basisObjekt = ?").setEntity(0, (Object)objekt).list();
                if (anhang49.size() > 0) {
                    fachdaten = (Anh49Fachdaten)anhang49.get(0);
                }
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anh49Fachdaten getAnh49ByObjekt(BasisObjekt objekt) {
        Anh49Fachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = Anh49Fachdaten.getAnh49ByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(Anh49Fachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh49Fachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    public static List findTuev(Integer tuev) {
        String query = "from Anh49Fachdaten anh49 where anh49.dekraTuevTermin = ? and anh49.basisObjekt.basisObjektarten.objektart not like 'Fettabscheider' order by anh49.basisObjekt.inaktiv, anh49.sachbearbeiterIn";
        Session session = HibernateSessionFactory.currentSession();
        List anhang49 = session.createQuery(query).setInteger(0, tuev.intValue()).list();
        HibernateSessionFactory.closeSession();
        return anhang49;
    }

    public static List findSachbearbeiter(String sachbearb) {
        String query = "from Anh49Fachdaten anh49 where anh49.sachbearbeiterIn = ? and anh49.basisObjekt.basisObjektarten.objektart not like 'Fettabscheider' order by anh49.basisObjekt.inaktiv";
        Session session = HibernateSessionFactory.currentSession();
        List anhang49 = session.createQuery(query).setString(0, sachbearb).list();
        HibernateSessionFactory.closeSession();
        return anhang49;
    }
}

