/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh49Analysen;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh49Analysen
extends AbstractAnh49Analysen
implements Serializable {
    public Anh49Analysen() {
    }

    public Anh49Analysen(Integer analysenid) {
        super(analysenid);
    }

    public String toString() {
        return "[Datum:" + this.getDatum() + ", " + this.getAnalysenid() + "]";
    }

    public static List getAnalyse(Anh49Fachdaten fd) {
        List analyse;
        try {
            Session session = HibernateSessionFactory.currentSession();
            analyse = session.createQuery("from Anh49Analysen as analyse where analyse.anh49Fachdaten = ? order by analyse.datum").setEntity(0, (Object)fd).list();
            AUIKataster.debugOutput("Analysen f\u00fcr " + fd + ", Anzahl: " + analyse.size(), "Anh49Analysen");
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return analyse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOrUpdateAnalyse(Anh49Analysen analyse) {
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)analyse);
                tx.commit();
            }
            catch (HibernateException e) {
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (Anh49Analysen)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeAnalyse(Anh49Analysen analyse) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)analyse);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh49AnalysenModel.objectRemoved", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

