/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh49Abscheiderdetails;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh49Abscheiderdetails
extends AbstractAnh49Abscheiderdetails
implements Serializable {
    public Anh49Abscheiderdetails() {
        short fW = 0;
        Short f = new Short(fW);
        this.setTankstelle(false);
        this.setSchlammfang(false);
        this.setBenzinOelabscheider(false);
        this.setKoaleszenzfilter(false);
        this.setIntegriert(false);
        this.setEmulsionsspaltanlage(false);
        this.setSchwimmer(false);
        this.setWohnhaus(false);
    }

    public Anh49Abscheiderdetails(Integer abscheiderid) {
        super(abscheiderid);
    }

    public String toString() {
        return "[ID:" + this.getAbscheiderid() + ", " + this.getAbscheidernr() + " von " + this.getVon() + ", " + this.getLage() + "]";
    }

    public static List getAbscheiderDetails(Anh49Fachdaten fd) {
        List details;
        try {
            Session session = HibernateSessionFactory.currentSession();
            details = session.createQuery("from Anh49Abscheiderdetails as details where details.Anh49Fachdaten = ? order by details.abscheidernr asc").setEntity(0, (Object)fd).list();
            AUIKataster.debugOutput("Details f\u00fcr " + fd + ", Anzahl: " + details.size(), "Anh49Abscheiderdetails");
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return details;
    }

    public static List getFettabschListe() {
        String query = "from Anh49Abscheiderdetails details where details.Anh49Fachdaten.basisObjekt.basisObjektarten.objektart like 'Fettabscheider' order by details.Anh49Fachdaten.basisObjekt.inaktiv, details.Anh49Fachdaten.basisObjekt.basisBetreiber.betrname";
        Session session = HibernateSessionFactory.currentSession();
        List fettabsch = session.createQuery(query).list();
        HibernateSessionFactory.closeSession();
        String query2 = "from Anh49Fachdaten anh49 where anh49.basisObjekt.basisObjektarten.objektart like 'Fettabscheider' order by anh49.basisObjekt.inaktiv, anh49.basisObjekt.basisBetreiber.betrname";
        session = HibernateSessionFactory.currentSession();
        List fettabsch2 = session.createQuery(query2).list();
        HibernateSessionFactory.closeSession();
        for (int j = 0; j < fettabsch2.size(); ++j) {
            Anh49Fachdaten item = (Anh49Fachdaten)fettabsch2.get(j);
            if (Anh49Abscheiderdetails.getAbscheiderDetails(item).size() != 0) continue;
            fettabsch.add(item);
        }
        return fettabsch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAbscheider(Anh49Abscheiderdetails absch) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)absch);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh49Abscheider.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeAbscheider(Anh49Abscheiderdetails abscheider) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)abscheider);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh49AbscheiderModel.objectRemoved", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

