/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.indeinl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AbstractAnh40Fachdaten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class Anh40Fachdaten
extends AbstractAnh40Fachdaten
implements Serializable {
    public String toString() {
        return "[Anhang 40:" + this.getBasisObjekt() + "]";
    }

    public static List getAuswertungsListe() {
        List liste;
        String query = "from Anh40Fachdaten as anh40 order by anh40.basisObjekt.inaktiv, anh40.id";
        try {
            Session session = HibernateSessionFactory.currentSession();
            liste = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException(e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return liste;
    }

    private static Anh40Fachdaten getAnh40ByObjekt(BasisObjekt objekt, Session session) throws HibernateException {
        List anhang40;
        Anh40Fachdaten fachdaten = null;
        if (objekt.getBasisObjektarten().isAnh40() && (anhang40 = session.createQuery("from Anh40Fachdaten as ah40 where ah40.basisObjekt = ?").setEntity(0, (Object)objekt).list()).size() > 0) {
            fachdaten = (Anh40Fachdaten)anhang40.get(0);
        }
        return fachdaten;
    }

    public static Anh40Fachdaten getAnh40ByObjekt(BasisObjekt objekt) {
        Anh40Fachdaten fachdaten2;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten2 = Anh40Fachdaten.getAnh40ByObjekt(objekt, session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            Object fachdaten2 = null;
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        return fachdaten2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAnh40(Anh40Fachdaten anh40) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)anh40);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "Anh40.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }
}

