/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.basis;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisStandort;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BasisStandort
extends AbstractBasisStandort
implements Serializable {
    public BasisStandort() {
    }

    public BasisStandort(Integer standortid) {
        super(standortid);
    }

    public String toString() {
        String strasse = this.getStrasse();
        String nr = "";
        if (this.getHausnr() != null && this.getHausnrzus() != null) {
            nr = " " + this.getHausnr() + this.getHausnrzus();
        } else if (this.getHausnr() != null) {
            nr = " " + this.getHausnr();
        }
        return strasse + nr;
    }

    public static BasisStandort getStandort(Integer id) {
        BasisStandort standort;
        try {
            Session session = HibernateSessionFactory.currentSession();
            standort = (BasisStandort)session.get(BasisStandort.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            standort = null;
        }
        return standort;
    }

    public static List findStandorte(String strasse, int hausnr) {
        List standorte;
        String strasse2 = strasse.toLowerCase().trim() + "%";
        Integer hausNummer = new Integer(hausnr);
        AUIKataster.debugOutput("Suche nach '" + strasse2 + "' Nr. " + hausnr, "BasisStandort.findStandorte");
        try {
            Session session = HibernateSessionFactory.currentSession();
            standorte = hausnr != -1 ? session.createQuery("from BasisStandort as bsta where lower(bsta.strasse) like ? and bsta.hausnr = ? order by bsta.strasse, bsta.hausnr").setString(0, strasse2).setInteger(1, hausNummer.intValue()).list() : session.createQuery("from BasisStandort as bsta where lower(bsta.strasse) like ? order by bsta.strasse, bsta.hausnr").setString(0, strasse2).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return standorte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasisStandort saveStandort(BasisStandort bsta) {
        BasisStandort bstaRet;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)bsta);
                bstaRet = bsta;
                tx.commit();
                AUIKataster.debugOutput("Neuer Standort " + bsta + " gespeichert!", "BasisStandort.saveStandort");
            }
            catch (HibernateException e) {
                bstaRet = null;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (BasisStandort)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return bstaRet;
    }

    private static String[] getEntwGebiete(Session session) throws HibernateException {
        List list = null;
        String suchString = "SELECT DISTINCT sta.entgebid FROM de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort sta";
        Query query = session.createQuery(suchString);
        query.setCacheable(true);
        query.setCacheRegion("ezgbliste");
        list = query.list();
        String[] tmp = new String[list.size()];
        tmp = list.toArray(tmp);
        return tmp;
    }

    public static String[] getEntwGebiete() {
        String[] tmp;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tmp = BasisStandort.getEntwGebiete(session);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (BasisStandort)", e);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStandort(BasisStandort standort) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)standort);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisStandort.removeStandort", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

