/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.basis;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisObjektchrono;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BasisObjektchrono
extends AbstractBasisObjektchrono
implements Serializable {
    public BasisObjektchrono() {
    }

    public BasisObjektchrono(Integer id) {
        super(id);
    }

    public static List getChronoByObjekt(BasisObjekt objekt) {
        List chrono;
        try {
            Session session = HibernateSessionFactory.currentSession();
            chrono = session.createQuery("from BasisObjektchrono oc where oc.basisObjekt = ? order by oc.datum, oc.wv").setEntity(0, (Object)objekt).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return chrono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveObjektChrono(BasisObjektchrono chrono) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)chrono);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisObjektchrono.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeObjektChrono(BasisObjektchrono chrono) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)chrono);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisObjektchrono.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }

    public String toString() {
        String tmp = this.getId() + ": ";
        if (this.getDatum() != null) {
            tmp = tmp + this.getDatum() + " ";
        }
        if (this.getSachverhalt() != null) {
            tmp = tmp + this.getSachverhalt();
        }
        return tmp;
    }
}

