/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.basis;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisObjektarten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BasisObjektarten
extends AbstractBasisObjektarten
implements Serializable {
    public static final int PROBEPUNKT = 32;
    public static final int BWK = 16;
    public static final int BHKW = 36;
    public static final int ANHANG_40 = 25;
    public static final int ANHANG_49 = 14;
    public static final int ABSCHEIDER = 19;
    public static final int FETTABSCHEIDER = 15;
    public static final int ANHANG_50 = 20;
    public static final int ANHANG_52 = 35;
    public static final int ANHANG_53_KLEIN = 17;
    public static final int ANHANG_53_GROSS = 18;
    public static final int SUEV = 13;
    public static final int ANHANG_55 = 29;
    public static final int ANHANG_56 = 30;
    public static final int UEBERGABESTELLE = 41;
    public static final int GENEHMIGUNG = 42;

    public BasisObjektarten() {
    }

    public BasisObjektarten(Integer objektartid) {
        super(objektartid);
    }

    public String toString() {
        String abteilung = "";
        if (this.getAbteilung() != null) {
            abteilung = " (" + this.getAbteilung() + ")";
        }
        return this.getObjektart() + abteilung;
    }

    public boolean isProbepunkt() {
        return 32 == this.getObjektartid();
    }

    public boolean isAnh40() {
        return 25 == this.getObjektartid();
    }

    public boolean isBWK() {
        if (16 == this.getObjektartid()) {
            return true;
        }
        return 36 == this.getObjektartid();
    }

    public boolean isAnh50() {
        return 20 == this.getObjektartid();
    }

    public boolean isAnh49() {
        if (14 == this.getObjektartid()) {
            return true;
        }
        if (19 == this.getObjektartid()) {
            return true;
        }
        return 15 == this.getObjektartid();
    }

    public boolean isFettabscheider() {
        return 15 == this.getObjektartid();
    }

    public boolean isAnh52() {
        return 35 == this.getObjektartid();
    }

    public boolean isAnh53Kl() {
        return 17 == this.getObjektartid();
    }

    public boolean isAnh53Gr() {
        return 18 == this.getObjektartid();
    }

    public boolean isAnh55() {
        return 29 == this.getObjektartid();
    }

    public boolean isAnh56() {
        return 30 == this.getObjektartid();
    }

    public boolean isSuev() {
        return 13 == this.getObjektartid();
    }

    public boolean isUebergabestelle() {
        return 41 == this.getObjektartid();
    }

    public boolean isGenehmigung() {
        return 42 == this.getObjektartid();
    }

    public boolean abteilungIs33() {
        String abteilung = this.getAbteilung();
        if (abteilung != null) {
            abteilung = abteilung.trim();
        }
        return "360.33".equals(abteilung);
    }

    public boolean abteilungIs34() {
        String abteilung = this.getAbteilung();
        if (abteilung != null) {
            abteilung = abteilung.trim();
        }
        return "360.34".equals(abteilung);
    }

    public static BasisObjektarten[] getObjektarten() {
        List list;
        try {
            Session session = HibernateSessionFactory.currentSession();
            String suchString = "from BasisObjektarten bo order by bo.objektart";
            Query query = session.createQuery(suchString);
            query.setCacheable(true);
            query.setCacheRegion("objartliste");
            list = query.list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        BasisObjektarten[] tmp = new BasisObjektarten[list.size()];
        tmp = list.toArray(tmp);
        return tmp;
    }

    public static BasisObjektarten getObjektart(Integer id) {
        BasisObjektarten art;
        try {
            Session session = HibernateSessionFactory.currentSession();
            art = (BasisObjektarten)session.get(BasisObjektarten.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            art = null;
        }
        return art;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasisObjektarten saveObjektart(BasisObjektarten art) {
        BasisObjektarten artRet;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)art);
                artRet = art;
                tx.commit();
                AUIKataster.debugOutput("Neue Objektart " + art + " gespeichert!", "BasisObjektarten.saveObejktart");
            }
            catch (HibernateException e) {
                artRet = null;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (BasisStandort)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return artRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeObjektart(BasisObjektarten objektart) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)objektart);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisObjektarten.removeObjektart", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

