/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.basis;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BasisObjekt
extends AbstractBasisObjekt
implements Serializable {
    public BasisObjekt() {
    }

    public BasisObjekt(Integer objektid) {
        super(objektid);
    }

    public String toString() {
        return "[ID:" + this.getObjektid() + ", Betr.:" + this.getBasisBetreiber() + ", Stdort:" + this.getBasisStandort() + ", Art:" + this.getBasisObjektarten() + "]";
    }

    public static List getObjekteByBetreiber(BasisBetreiber betr, String abteilung) {
        List objekte;
        String query = "from BasisObjekt as bo where bo.basisBetreiber = ?";
        if (abteilung != null) {
            query = query + "and bo.basisObjektarten.abteilung = '" + abteilung + "' ";
        }
        query = query + "order by bo.inaktiv, bo.basisStandort.strasse, bo.basisStandort.hausnr, bo.basisObjektarten.objektart";
        try {
            Session session = HibernateSessionFactory.currentSession();
            objekte = session.createQuery(query).setEntity(0, (Object)betr).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return objekte;
    }

    public static List getObjekteByStandort(BasisStandort standort, String abteilung, Integer nichtartid) {
        List objekte;
        String query = "from BasisObjekt as bo where bo.basisStandort = ? ";
        if (abteilung != null) {
            query = query + "and bo.basisObjektarten.abteilung = '" + abteilung + "' ";
        }
        if (nichtartid != null) {
            query = query + "and bo.basisObjektarten.objektartid != " + nichtartid;
        }
        query = query + "order by bo.inaktiv, bo.basisBetreiber.betrname, bo.basisObjektarten.objektart";
        try {
            Session session = HibernateSessionFactory.currentSession();
            objekte = session.createQuery(query).setEntity(0, (Object)standort).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return objekte;
    }

    public static List getObjekteByStandort(BasisStandort standort, Integer istartid) {
        List objekte;
        String query = "from BasisObjekt as bo where bo.basisStandort = ? ";
        if (istartid != null) {
            query = query + "and bo.basisObjektarten.objektartid = ?";
        }
        query = query + "order by bo.inaktiv, bo.basisBetreiber.betrname, bo.basisObjektarten.objektart";
        try {
            Session session = HibernateSessionFactory.currentSession();
            objekte = session.createQuery(query).setEntity(0, (Object)standort).setInteger(1, 32).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return objekte;
    }

    public static BasisObjekt getObjekt(Integer id) {
        BasisObjekt objekt;
        try {
            Session session = HibernateSessionFactory.currentSession();
            objekt = (BasisObjekt)session.get(BasisObjekt.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            objekt = null;
        }
        return objekt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasisObjekt saveBasisObjekt(BasisObjekt obj) {
        BasisObjekt saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)obj);
            saved = obj;
            tx.commit();
        }
        catch (HibernateException e) {
            saved = null;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisObjekt.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeBasisObjekt(BasisObjekt obj) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)obj);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisObjektModel.objectRemoved", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

