/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.basis;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.AbstractBasisBetreiber;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class BasisBetreiber
extends AbstractBasisBetreiber
implements Serializable {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_ANREDE = "anrede";
    public static final String PROPERTY_ZUSATZ = "zusatz";

    public BasisBetreiber() {
    }

    public BasisBetreiber(Integer betreiberid) {
        super(betreiberid);
    }

    public String toString() {
        String name = this.getBetrname();
        String zusatz = "";
        if (this.getBetrnamezus() != null) {
            zusatz = ", " + this.getBetrnamezus();
        }
        return name + zusatz;
    }

    public static BasisBetreiber getBetreiber(Integer id) {
        BasisBetreiber betreiber;
        try {
            Session session = HibernateSessionFactory.currentSession();
            betreiber = (BasisBetreiber)session.get(BasisBetreiber.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            betreiber = null;
        }
        return betreiber;
    }

    public static List findBetreiber(String suche, String property) {
        List betreiber;
        String suche2 = suche.toLowerCase().trim() + "%";
        AUIKataster.debugOutput("Suche nach '" + suche2 + "' (" + property + ").", "BasisBetreiber.findBetreiber");
        String queryString = PROPERTY_NAME.equals(property) ? "from BasisBetreiber as betr where lower(betr.betrname) like ?order by betr.betrname, betr.betrnamezus" : (PROPERTY_ANREDE.equals(property) ? "from BasisBetreiber as betr where lower(betr.betranrede) like ?order by betr.betrname, betr.betrnamezus" : (PROPERTY_ZUSATZ.equals(property) ? "from BasisBetreiber as betr where lower(betr.betrnamezus) like ?order by betr.betrname, betr.betrnamezus" : "from BasisBetreiber as betr where lower(betr.betrname) like ?or lower(betr.betranrede) like ?or lower(betr.betrnamezus) like ?order by betr.betrname, betr.betrnamezus"));
        try {
            Session session = HibernateSessionFactory.currentSession();
            betreiber = property != null ? session.createQuery(queryString).setString(0, suche2).list() : session.createQuery(queryString).setString(0, suche2).setString(1, suche2).setString(2, suche2).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return betreiber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasisBetreiber saveBetreiber(BasisBetreiber betr) {
        BasisBetreiber betrRet;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                betrRet = (BasisBetreiber)session.merge((Object)betr);
                tx.commit();
                AUIKataster.debugOutput("Neuer Betr " + betr + " gespeichert!", "BasisStandort.saveStandort");
            }
            catch (HibernateException e) {
                betrRet = null;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (BasisBetreiber)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return betrRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeBetreiber(BasisBetreiber betreiber) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)betreiber);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "BasisBetreiber.removeBetreiber", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }

    public String getBetriebsgrundstueck() {
        String strasse = this.getStrasse();
        Integer hausnr = this.getHausnr();
        String hausnrZus = this.getHausnrzus();
        StringBuilder sb = new StringBuilder(strasse);
        if (hausnr != null) {
            sb.append(" ");
            sb.append(hausnr.toString());
        }
        if (hausnr != null && hausnrZus != null) {
            sb.append(hausnrZus);
        }
        return sb.toString();
    }
}

