/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlEinheiten;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class AtlStatus
extends AbstractAtlEinheiten
implements Serializable {
    public AtlStatus() {
    }

    public AtlStatus(Integer id) {
        super(id);
    }

    public String toString() {
        String tmp = this.getBezeichnung();
        if (tmp != null) {
            tmp = tmp.trim();
        }
        return tmp;
    }

    public static AtlStatus[] getStatus() {
        AtlStatus[] tmp;
        try {
            Session session = HibernateSessionFactory.currentSession();
            List einheiten = session.createQuery("from AtlStatus as status").list();
            tmp = new AtlStatus[einheiten.size()];
            tmp = einheiten.toArray(tmp);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    public static AtlStatus getStatus(String bezeichnung) {
        AtlStatus[] status;
        for (AtlStatus s : status = AtlStatus.getStatus()) {
            if (!bezeichnung.equals(s.getBezeichnung())) continue;
            return s;
        }
        return null;
    }

    public static AtlStatus getStatus(int id) {
        AtlStatus[] status;
        for (AtlStatus s : status = AtlStatus.getStatus()) {
            if (id != s.getId()) continue;
            return s;
        }
        return null;
    }

    public static String[] getStatusAsString() {
        AtlStatus[] status = AtlStatus.getStatus();
        String[] str = new String[status.length];
        int idx = 0;
        for (AtlStatus s : status) {
            str[idx++] = s.getBezeichnung();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlStatus getEinheit(Integer id) {
        AtlStatus status;
        if (id != null) {
            try {
                Session session = HibernateSessionFactory.currentSession();
                status = (AtlStatus)session.get(AtlStatus.class, (Serializable)id);
            }
            catch (HibernateException e) {
                e.printStackTrace();
                status = null;
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        } else {
            status = null;
        }
        return status;
    }
}

