/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlSielhaut;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AtlSielhaut
extends AbstractAtlSielhaut
implements Serializable {
    public AtlSielhaut() {
        Double zero = new Double(0.0);
        this.setRechtswert(zero);
        this.setHochwert(zero);
    }

    public AtlSielhaut(Integer id) {
        super(id);
    }

    public String toString() {
        return "[SielhautBearbeiten:" + this.getId() + ", " + this.getBezeichnung() + "]";
    }

    public static List findPunkte(String suche) {
        List punkte;
        String sucheF = suche.toLowerCase().trim() + "%";
        try {
            Session session = HibernateSessionFactory.currentSession();
            punkte = session.createQuery("from AtlSielhaut as sp where lower(sp.bezeichnung) like ? order by sp.psielhaut desc, sp.pfirmenprobe desc, sp.bezeichnung").setString(0, sucheF).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return punkte;
    }

    public static AtlSielhaut getSielhautByBez(String bezeichnung) {
        AtlSielhaut sielhaut2;
        String sucheF = bezeichnung.toLowerCase().trim() + "%";
        try {
            Session session = HibernateSessionFactory.currentSession();
            List punkte = session.createQuery("from AtlSielhaut as sp where lower(sp.bezeichnung) like ? order by sp.psielhaut desc, sp.pfirmenprobe desc, sp.bezeichnung").setString(0, sucheF).list();
            sielhaut2 = punkte.size() > 0 ? (AtlSielhaut)punkte.get(0) : null;
        }
        catch (HibernateException e) {
            Object sielhaut2 = null;
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return sielhaut2;
    }

    public static AtlSielhaut getSielhaut(Integer id) {
        AtlSielhaut sielhaut;
        try {
            Session session = HibernateSessionFactory.currentSession();
            sielhaut = (AtlSielhaut)session.get(AtlSielhaut.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            sielhaut = null;
        }
        return sielhaut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveSielhautPunkt(AtlSielhaut spunkt) {
        boolean success;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)spunkt);
                tx.commit();
                success = true;
                AUIKataster.debugOutput("Sielhautpunkt " + spunkt + " erfolgreich gespeichert!", "AtlSielhaut");
            }
            catch (HibernateException e) {
                success = false;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler: tx.rollback() nicht m\u00f6glich! (AtlSielhaut)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return success;
    }
}

