/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AtlProbepkt
extends AbstractAtlProbepkt
implements Serializable {
    public AtlProbepkt() {
    }

    public AtlProbepkt(Integer objektid) {
        super(objektid);
    }

    public String toString() {
        return "[Probepunkt:" + this.getObjektid() + ", Art:" + this.getAtlProbeart() + ", Nr:" + this.getNummer() + "]";
    }

    public static AtlProbepkt getKlaerschlammProbepunkt(AtlProbeart art, AtlKlaeranlagen ka) {
        List pkte;
        try {
            Session session = HibernateSessionFactory.currentSession();
            pkte = session.createQuery("from AtlProbepkt as probepkt where probepkt.atlProbeart = ? and probepkt.atlKlaeranlagen = ? order by probepkt.objektid asc").setEntity(0, (Object)art).setEntity(1, (Object)ka).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlProbepkt)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        AtlProbepkt tmp = pkte.size() > 0 ? (AtlProbepkt)pkte.get(0) : null;
        return tmp;
    }

    private static AtlProbepkt getProbepunkt(Session session, Integer id) {
        AtlProbepkt punkt = null;
        try {
            List pkte = session.createQuery("from AtlProbepkt as probepkt where probepkt.objektid = ?").setInteger(0, id.intValue()).list();
            if (pkte.size() > 0) {
                punkt = (AtlProbepkt)pkte.get(0);
            }
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        return punkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlProbepkt getProbepunkt(Integer id) {
        AtlProbepkt pkt = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            pkt = AtlProbepkt.getProbepunkt(session, id);
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return pkt;
    }

    private static AtlProbepkt getProbepunktByObjekt(BasisObjekt objekt, Session session) {
        AtlProbepkt punkt = null;
        if (objekt != null) {
            try {
                List pkte = session.createQuery("from AtlProbepkt as probepkt where probepkt.basisObjekt = ?").setEntity(0, (Object)objekt).list();
                if (pkte.size() > 0) {
                    punkt = (AtlProbepkt)pkte.get(0);
                }
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler (AtlProbepkt)", e);
            }
        }
        return punkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlProbepkt getProbepunktByObjekt(BasisObjekt objekt) {
        AtlProbepkt punkt;
        try {
            Session session = HibernateSessionFactory.currentSession();
            punkt = AtlProbepkt.getProbepunktByObjekt(objekt, session);
        }
        catch (HibernateException e) {
            punkt = null;
            e.printStackTrace();
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return punkt;
    }

    public static AtlProbepkt getSielhautProbepunkt(AtlSielhaut siel) {
        AtlProbepkt punkt;
        try {
            Session session = HibernateSessionFactory.currentSession();
            List pkte = session.createQuery("from AtlProbepkt as probepkt where probepkt.atlSielhaut = ?").setEntity(0, (Object)siel).list();
            if (pkte.size() > 0) {
                punkt = (AtlProbepkt)pkte.get(0);
                AUIKataster.debugOutput("SielhautBearbeiten-Probepunkt " + punkt + " aus DB geholt.", "AtlProbepkt");
            } else {
                punkt = null;
            }
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return punkt;
    }

    public static List getProbenehmerpunkte() {
        List pkte;
        try {
            Session session = HibernateSessionFactory.currentSession();
            pkte = session.createQuery("select distinct pk from AtlProbepkt as pk inner join pk.atlProbenahmen as pn where pn.kennummer like '3%' ").list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return pkte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProbepunkt(AtlProbepkt punkt) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)punkt);
            tx.commit();
            saved = true;
            AUIKataster.debugOutput("Probepunkt " + punkt + " gespeichert.", "AtlProbepkt");
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "AtlProbepkt.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeProbepunkt(AtlProbepkt punkt) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)punkt);
            tx.commit();
            removed = true;
            AUIKataster.debugOutput("Probepunkt " + punkt + " gespeichert.", "ProbepunktPanel.saveProbepunktDaten");
        }
        catch (HibernateException e) {
            removed = false;
            AUIKataster.debugOutput("Probepunkt " + punkt + " konnte nicht gespeichert werden!", "ProbepunktPanel.saveProbepunktDaten");
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "ProbepunktPanel.saveProbepunktDaten", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }

    public BasisBetreiber getBasisBetreiber() {
        BasisObjekt basisObj = this.getBasisObjekt();
        return basisObj != null ? basisObj.getBasisBetreiber() : null;
    }
}

