/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.JRMapDataSource;
import de.bielefeld.umweltamt.aui.utils.KommaDouble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AtlProbenahmen
extends AbstractAtlProbenahmen
implements Serializable {
    public static final String[] COLUMNS_AUFTRAG = new String[]{"auswahl", "Parameter", "Kennzeichnung", "Konservierung"};
    public static final String[] COLUMNS_BESCHEID = new String[]{"Pos", "Parameter", "Grenzwert", "Ergebnis_Wert", "Ergebnis_Einheit", "Geb\u00fchr"};

    public AtlProbenahmen() {
    }

    public AtlProbenahmen(Integer id) {
        super(id);
    }

    public static List getKSProbenahmen(AtlProbeart art, AtlKlaeranlagen ka) {
        List proben;
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = session.createQuery("from AtlProbenahmen as probenahme where probenahme.atlProbepkt.atlProbeart = ? and probenahme.atlProbepkt.atlKlaeranlagen = ? order by probenahme.datumDerEntnahme desc, probenahme.kennummer desc").setEntity(0, (Object)art).setEntity(1, (Object)ka).list();
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        return proben;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getProbenahmen(AtlProbepkt pkt, boolean loadPos, int limit) {
        if (pkt.getObjektid() == null) return new ArrayList();
        try {
            Session session = HibernateSessionFactory.currentSession();
            Query query = session.createQuery("from AtlProbenahmen as probenahme where probenahme.atlProbepkt = ? order by probenahme.datumDerEntnahme desc, probenahme.kennummer desc");
            query.setParameter(0, (Object)pkt, Hibernate.entity(AtlProbepkt.class));
            if (limit != -1) {
                query.setMaxResults(5);
            }
            List proben = query.list();
            if (!loadPos) return proben;
            int i = 0;
            while (i < proben.size()) {
                AtlProbenahmen probe = (AtlProbenahmen)proben.get(i);
                Hibernate.initialize((Object)probe.getAtlAnalysepositionen());
                ++i;
            }
            return proben;
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
    }

    public static List findProbenahmen(String suche, String property) {
        List proben;
        String suche2 = suche.toLowerCase().trim() + "%";
        AUIKataster.debugOutput("Suche nach '" + suche2 + "' (" + property + ").", "AtlProbenahmen.findProbenahmen");
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = session.createQuery("from AtlProbenahmen as probenahme where lower(probenahme." + property + ") like ? " + "order by probenahme.datumDerEntnahme desc, probenahme.kennummer desc").setString(0, suche2).list();
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        return proben;
    }

    public static boolean probenahmeExists(String kennnummer) {
        int count;
        String Kennummer = kennnummer;
        try {
            Session session = HibernateSessionFactory.currentSession();
            List liste = session.createQuery("from AtlProbenahmen pn where pn.kennummer = ?").setString(0, kennnummer).list();
            count = session.createQuery("from AtlProbenahmen pn where pn.kennummer = ?").setString(0, kennnummer).list().size();
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        return count >= 1;
    }

    public static AtlProbenahmen getProbenahme(Integer id) {
        return AtlProbenahmen.getProbenahme(id, false);
    }

    public static AtlProbenahmen getProbenahme(Integer id, boolean loadPos) {
        AtlProbenahmen probe;
        try {
            Session session = HibernateSessionFactory.currentSession();
            probe = (AtlProbenahmen)session.get(AtlProbenahmen.class, (Serializable)id);
            if (loadPos && probe != null) {
                Hibernate.initialize((Object)probe.getAtlAnalysepositionen());
                AUIKataster.debugOutput("APos geladen:\n " + probe.getAtlAnalysepositionen());
            }
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlProbenahmen)", e);
        }
        return probe;
    }

    public static AtlProbenahmen getProbenahme(String kennummer, boolean loadPos) {
        AtlProbenahmen probe;
        try {
            Session session = HibernateSessionFactory.currentSession();
            probe = (AtlProbenahmen)session.createQuery("from AtlProbenahmen where kennummer = ?").setString(0, kennummer).uniqueResult();
            if (loadPos && probe != null) {
                Hibernate.initialize((Object)probe.getAtlAnalysepositionen());
                AUIKataster.debugOutput("APos geladen:\n " + probe.getAtlAnalysepositionen());
            }
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlProbenahmen)", e);
        }
        return probe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveProbenahme(AtlProbenahmen probe) {
        boolean success;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.save((Object)probe);
                tx.commit();
                success = true;
            }
            catch (HibernateException e) {
                success = false;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (Anh49Ortstermine)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateProbenahme(AtlProbenahmen probe) {
        boolean success;
        block7: {
            Transaction tx = null;
            try {
                Session session = HibernateSessionFactory.currentSession();
                tx = session.beginTransaction();
                session.saveOrUpdate((Object)probe);
                tx.commit();
                success = true;
            }
            catch (HibernateException e) {
                success = false;
                e.printStackTrace();
                if (tx == null) break block7;
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    throw new RuntimeException("Datenbank-Fehler (Anh49Ortstermine)", e);
                }
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeProbenahme(AtlProbenahmen probe) {
        boolean success;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)probe);
            tx.commit();
            success = true;
        }
        catch (HibernateException e) {
            success = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "ProbenahmenModel.objectRemoved", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return success;
    }

    public static List sortAnalysepositionen(AtlProbenahmen probe) {
        List sortedPositionen;
        try {
            Session session = HibernateSessionFactory.currentSession();
            AtlProbenahmen newProbe = (AtlProbenahmen)session.get(AtlProbenahmen.class, (Serializable)probe.getId());
            sortedPositionen = session.createFilter((Object)newProbe.getAtlAnalysepositionen(), "order by lower(this.atlParameter.bezeichnung) asc, this.atlEinheiten.id desc, this.wert desc").list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlAnalysepos.)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return sortedPositionen;
    }

    public static JRMapDataSource getAuftragDataSource(AtlProbenahmen probe) {
        List sorted = AtlProbenahmen.sortAnalysepositionen(probe);
        int elements = sorted.size();
        Object[][] values = new Object[elements][];
        for (int i = 0; i < elements; ++i) {
            Object[] columns = new Object[4];
            AtlAnalyseposition pos = (AtlAnalyseposition)sorted.get(i);
            AtlParameter parameter = pos.getAtlParameter();
            String bezeichnung = parameter.getBezeichnung();
            columns[0] = true;
            columns[1] = bezeichnung;
            columns[2] = "";
            columns[3] = "";
            values[i] = columns;
        }
        return new JRMapDataSource(COLUMNS_AUFTRAG, values);
    }

    public static JRMapDataSource getBescheidDataSource(AtlProbenahmen probe) {
        List sorted = AtlProbenahmen.sortAnalysepositionen(probe);
        int elements = sorted.size();
        Object[][] values = new Object[elements][];
        for (int i = 0; i < elements; ++i) {
            Object[] columns = new Object[6];
            AtlAnalyseposition pos = (AtlAnalyseposition)sorted.get(i);
            AtlParameter parameter = pos.getAtlParameter();
            String einheit = pos.getAtlEinheiten().getBezeichnung();
            Double grenzwert = parameter.getGrenzwert();
            columns[0] = i + 1;
            columns[1] = parameter.getBezeichnung();
            columns[2] = grenzwert != null ? grenzwert + " " + einheit : "";
            columns[3] = pos.getWert();
            columns[4] = einheit;
            columns[5] = new KommaDouble(parameter.getPreisfueranalyse()).toString() + " \u20ac";
            values[i] = columns;
        }
        return new JRMapDataSource(COLUMNS_BESCHEID, values);
    }

    public String toString() {
        String tmp = "[Probe: " + this.getKennummer() + ", " + this.getProbeArt() + ", " + AuikUtils.getStringFromDate(this.getDatumDerEntnahme());
        if (this.getZeitDerEntnahmen() != null) {
            tmp = tmp + " " + this.getZeitDerEntnahmen();
        }
        tmp = tmp + ", ";
        tmp = Hibernate.isInitialized((Object)this.getAtlAnalysepositionen()) ? tmp + this.getAtlAnalysepositionen().size() : tmp + "N/A";
        tmp = tmp + "]";
        return tmp;
    }

    public AtlProbeart getProbeArt() {
        return this.getAtlProbepkt().getAtlProbeart();
    }

    public boolean isKlaerschlammProbe() {
        if (this.getProbeArt().isFaulschlamm()) {
            return true;
        }
        return this.getProbeArt().isRohschlamm();
    }

    public boolean isAnalysepositionenInitialized() {
        return Hibernate.isInitialized((Object)this.getAtlAnalysepositionen());
    }

    public void addAnalyseposition(AtlAnalyseposition pos) {
        pos.setAtlProbenahmen(this);
        this.getAtlAnalysepositionen().add(pos);
    }

    public AtlAnalyseposition findAtlAnalyseposition(AtlParameter parameter, AtlEinheiten einheit, boolean createNew) {
        String ordnungsbegriff = parameter.getOrdnungsbegriff();
        Set positionen = this.getAtlAnalysepositionen();
        for (AtlAnalyseposition tmp : positionen) {
            AtlParameter param = tmp.getAtlParameter();
            if (!ordnungsbegriff.equals(param.getOrdnungsbegriff())) continue;
            return tmp;
        }
        if (!createNew) {
            return null;
        }
        AtlAnalyseposition neu = new AtlAnalyseposition(this);
        neu.setAtlParameter(parameter);
        neu.setAtlEinheiten(einheit);
        this.addAnalyseposition(neu);
        return neu;
    }

    public AtlAnalyseposition findAtlAnalyseposition(AtlParameter parameter, AtlEinheiten einheit) {
        return this.findAtlAnalyseposition(parameter, einheit, true);
    }

    public BasisBetreiber getBasisBetreiber() {
        AtlProbepkt pkt = this.getAtlProbepkt();
        return pkt != null ? pkt.getBasisBetreiber() : null;
    }
}

