/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlProbeart;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class AtlProbeart
extends AbstractAtlProbeart
implements Serializable {
    public static final Integer ABWASSER = new Integer(1);
    public static final Integer ABWASSER_UWB = new Integer(2);
    public static final Integer ABWASSER_ES = new Integer(3);
    public static final Integer ANLIEFERUNG = new Integer(4);
    public static final Integer FAULSCHLAMM = new Integer(5);
    public static final Integer ROHSCHLAMM = new Integer(6);
    public static final Integer SIELHAUT = new Integer(7);
    public static final Integer SONSTIGE = new Integer(8);
    public static final Integer ZULAUF = new Integer(9);

    public AtlProbeart() {
    }

    public AtlProbeart(Integer artId) {
        super(artId);
    }

    public String toString() {
        return this.getArt();
    }

    public boolean isAbwasser() {
        return ABWASSER.equals(this.getArtId());
    }

    public boolean isAbwasserUWB() {
        return ABWASSER_UWB.equals(this.getArtId());
    }

    public boolean isAbwasserES() {
        return ABWASSER_ES.equals(this.getArtId());
    }

    public boolean isAnlieferung() {
        return ANLIEFERUNG.equals(this.getArtId());
    }

    public boolean isFaulschlamm() {
        return FAULSCHLAMM.equals(this.getArtId());
    }

    public boolean isRohschlamm() {
        return ROHSCHLAMM.equals(this.getArtId());
    }

    public boolean isSielhaut() {
        return SIELHAUT.equals(this.getArtId());
    }

    public boolean isSonstige() {
        return SONSTIGE.equals(this.getArtId());
    }

    public boolean isZulauf() {
        return ZULAUF.equals(this.getArtId());
    }

    public static AtlProbeart[] getProbearten(Session session) throws HibernateException {
        List list = null;
        String suchString = "from AtlProbeart art order by art.artId";
        Query query = session.createQuery(suchString);
        query.setCacheable(true);
        query.setCacheRegion("probeartliste");
        list = query.list();
        AtlProbeart[] tmp = new AtlProbeart[list.size()];
        tmp = list.toArray(tmp);
        return tmp;
    }

    public static AtlProbeart[] getProbearten() {
        AtlProbeart[] tmp = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tmp = AtlProbeart.getProbearten(session);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlProbeart getProbeart(Integer id) {
        AtlProbeart art;
        try {
            Session session = HibernateSessionFactory.currentSession();
            art = (AtlProbeart)session.get(AtlProbeart.class, (Serializable)id);
        }
        catch (HibernateException e) {
            e.printStackTrace();
            art = null;
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return art;
    }
}

