/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlParameter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class AtlParameter
extends AbstractAtlParameter
implements Serializable {
    public static final String AOX_ID = "L13430";
    public static final String SILBER_ID = "B00210";
    public static final String GOLD_ID = "L11400";
    public static final String ALUMINIUM_ID = "L11310";
    public static final String ARSEN_ID = "L11420";
    public static final String BOR_ID = "L12110";
    public static final String BARIUM_ID = "B00070";
    public static final String CALCIUM_ID = "L11220";
    public static final String CADMIUM_ID = "L11650";
    public static final String KOBALT_ID = "B00108";
    public static final String CHROM_ID = "L11510";
    public static final String KUPFER_ID = "L11610";
    public static final String EISEN_ID = "B00041";
    public static final String QUECKSILBER_ID = "L11660";
    public static final String KALIUM_ID = "L11130";
    public static final String MAGNESIUM_ID = "L11210";
    public static final String MANGAN_ID = "L11710";
    public static final String NATRIUM_ID = "L11120";
    public static final String NICKEL_ID = "L11880";
    public static final String ORTHOPHOSPHAT_ID = "B00127";
    public static final String PHOSPHAT_ID = "B00018";
    public static final String BLEI_ID = "L11380";
    public static final String STRONTIUM_ID = "B00190";
    public static final String ZINK_ID = "L11640";
    public static final String ZIRKONIUM_ID = "B00408";
    public static final String TROCKENSUBSTANZ_ID = "B00107";
    public static final String DEFAULT_ID = "L11380";
    private static Map sParams = null;

    public AtlParameter() {
    }

    public AtlParameter(String ordnungsbegriff) {
        super(ordnungsbegriff);
    }

    public String toString() {
        String tmp = this.getBezeichnung();
        if (tmp != null) {
            tmp = tmp.trim();
        }
        return tmp;
    }

    public static String getOrdnungsbegriff(String name) {
        AtlParameter.initMap();
        return (String)sParams.get(name);
    }

    private static void initMap() {
        if (sParams == null) {
            sParams = new HashMap();
            sParams.put("Blei", "L11380");
            sParams.put("Cadmium", CADMIUM_ID);
            sParams.put("Chrom ges.", CHROM_ID);
            sParams.put("Gold", GOLD_ID);
            sParams.put("Kupfer", KUPFER_ID);
            sParams.put("Nickel", NICKEL_ID);
            sParams.put("Quecksilber", QUECKSILBER_ID);
            sParams.put("Silber", SILBER_ID);
            sParams.put("Trockensubstanz", TROCKENSUBSTANZ_ID);
            sParams.put("Zink", ZINK_ID);
            sParams.put("Ag", SILBER_ID);
            sParams.put("Au", GOLD_ID);
            sParams.put("Al", ALUMINIUM_ID);
            sParams.put("As", ARSEN_ID);
            sParams.put("B", BOR_ID);
            sParams.put("Ba", BARIUM_ID);
            sParams.put("Ca", CALCIUM_ID);
            sParams.put("Cd", CADMIUM_ID);
            sParams.put("Co", KOBALT_ID);
            sParams.put("Cr", CHROM_ID);
            sParams.put("Cu", KUPFER_ID);
            sParams.put("Fe", EISEN_ID);
            sParams.put("Hg", QUECKSILBER_ID);
            sParams.put("K", KALIUM_ID);
            sParams.put("Mg", MAGNESIUM_ID);
            sParams.put("Mn", MANGAN_ID);
            sParams.put("Na", NATRIUM_ID);
            sParams.put("Ni", NICKEL_ID);
            sParams.put("Pb", "L11380");
            sParams.put("Sr", STRONTIUM_ID);
            sParams.put("Zn", ZINK_ID);
            sParams.put("Zr", ZIRKONIUM_ID);
        }
    }

    public static boolean isParameterSupported(String name) {
        AtlParameter.initMap();
        return sParams.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlParameter getParameter(String id) {
        AtlParameter parameter;
        if (id != null) {
            try {
                Session session = HibernateSessionFactory.currentSession();
                parameter = (AtlParameter)session.get(AtlParameter.class, (Serializable)((Object)id));
            }
            catch (HibernateException e) {
                e.printStackTrace();
                parameter = null;
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        } else {
            parameter = null;
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getParameter() throws HibernateException {
        List parameter = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            parameter = session.createQuery("from AtlParameter as param order by param.bezeichnung").list();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlParameter[] getRelevanteParameter() {
        AtlParameter[] tmp = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            List parameter = session.createQuery("from AtlParameter as param where param.sielhautGw is not null or param.klaerschlammGw is not null or param.bezeichnung like 'lipophile Stoffe' or param.bezeichnung like 'Sulfat (SO4)'or param.bezeichnung like 'Fluorid (F)'or param.bezeichnung like 'CSB'or param.bezeichnung like 'BSB 5'order by param.bezeichnung").list();
            tmp = new AtlParameter[parameter.size()];
            tmp = parameter.toArray(tmp);
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlParameter[] getParameterGroup(int id) {
        try {
            Session session = HibernateSessionFactory.currentSession();
            List p = session.createQuery("from AtlParameter as param where param.atlParameterGruppe.id = " + id).list();
            AtlParameter[] atlParameterArray = p.toArray(new AtlParameter[p.size()]);
            return atlParameterArray;
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return null;
    }
}

