/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlEinheiten;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class AtlEinheiten
extends AbstractAtlEinheiten
implements Serializable {
    public static final Integer MG_L_ID = new Integer(42);
    public static final Integer MG_KG_ID = new Integer(43);
    public static final Integer PROZENT_ID = new Integer(63);
    public static final Integer DEFAULT_ID = MG_L_ID;
    private static Map sEinheiten = null;

    public AtlEinheiten() {
    }

    public AtlEinheiten(Integer id) {
        super(id);
    }

    public String toString() {
        String tmp = this.getBezeichnung();
        if (tmp != null) {
            tmp = tmp.trim();
        }
        return tmp;
    }

    private static void initMap() {
        if (sEinheiten == null) {
            sEinheiten = new HashMap();
            sEinheiten.put("mg/kg TS", MG_KG_ID);
            sEinheiten.put("%", PROZENT_ID);
        }
    }

    public static boolean isEinheitSupported(String name) {
        AtlEinheiten.initMap();
        return sEinheiten.containsKey(name);
    }

    public static Integer getID(String name) {
        AtlEinheiten.initMap();
        return (Integer)sEinheiten.get(name);
    }

    public static AtlEinheiten[] getEinheiten() {
        AtlEinheiten[] tmp;
        try {
            Session session = HibernateSessionFactory.currentSession();
            List einheiten = session.createQuery("from AtlEinheiten as einheit").list();
            tmp = new AtlEinheiten[einheiten.size()];
            tmp = einheiten.toArray(tmp);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlEinheiten getEinheit(Integer id) {
        AtlEinheiten einheit;
        if (id != null) {
            try {
                Session session = HibernateSessionFactory.currentSession();
                einheit = (AtlEinheiten)session.get(AtlEinheiten.class, (Serializable)id);
            }
            catch (HibernateException e) {
                e.printStackTrace();
                einheit = null;
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        } else {
            einheit = null;
        }
        return einheit;
    }
}

