/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.atl;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.atl.AbstractAtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class AtlAnalyseposition
extends AbstractAtlAnalyseposition
implements Serializable {
    public AtlAnalyseposition() {
        this(new Float(0.0));
    }

    public AtlAnalyseposition(Float wert) {
        this.setWert(wert);
    }

    public AtlAnalyseposition(AtlProbenahmen probe) {
        this(new Float(0.0));
        this.setAtlProbenahmen(probe);
    }

    public AtlAnalyseposition(Integer id) {
        super(id);
        this.setWert(new Float(0.0));
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof AtlAnalyseposition)) {
            return false;
        }
        AtlAnalyseposition that = (AtlAnalyseposition)rhs;
        if (this.getId() != null && that.getId() != null) {
            return this.getId().equals(that.getId());
        }
        if (this.getId() != null || that.getId() != null) {
            return false;
        }
        if (this.getWert() != null ? !this.getWert().equals(that.getWert()) : that.getWert() != null) {
            return false;
        }
        if (this.getAtlParameter() != null ? !this.getAtlParameter().equals(that.getAtlParameter()) : that.getAtlParameter() != null) {
            return false;
        }
        if (this.getAtlEinheiten() != null ? !this.getAtlEinheiten().equals(that.getAtlEinheiten()) : that.getAtlEinheiten() != null) {
            return false;
        }
        return !(this.getAnalyseVon() != null ? !this.getAnalyseVon().equals(that.getAnalyseVon()) : that.getAnalyseVon() != null);
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            int result = 17;
            int idValue = 0;
            if (this.getId() != null) {
                idValue = this.getId().hashCode();
            } else if (this.getWert() != null) {
                idValue = this.getWert().hashCode();
                if (this.getAtlParameter() != null) {
                    result += this.getAtlParameter().hashCode();
                }
                if (this.getAtlEinheiten() != null) {
                    result += this.getAtlEinheiten().hashCode();
                }
                if (this.getAnalyseVon() != null) {
                    result += this.getAnalyseVon().hashCode();
                }
            }
            this.hashValue = result = 37 * result + idValue;
        }
        return this.hashValue;
    }

    public String toString() {
        String tmp = "[Position: " + this.getAtlParameter() + ": " + this.getWert() + " " + this.getAtlEinheiten() + ", " + this.getAnalyseVon() + ", ";
        if (this.getAtlProbenahmen() != null) {
            tmp = tmp + this.getAtlProbenahmen() + ", ";
        }
        tmp = this.getId() != null ? tmp + "ID:" + this.getId() : tmp + "UNSAVED";
        tmp = tmp + "]";
        return tmp;
    }

    public static AtlAnalyseposition getAnalysepositionObjekt(Integer id) {
        AtlAnalyseposition objekt;
        try {
            Session session = HibernateSessionFactory.currentSession();
            objekt = (AtlAnalyseposition)session.get(AtlAnalyseposition.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            objekt = null;
        }
        return objekt;
    }

    public static List getAnalysepositionen(AtlProbenahmen probe, AtlParameter param) {
        if (!Hibernate.isInitialized((Object)probe.getAtlAnalysepositionen())) {
            // empty if block
        }
        ArrayList<AtlAnalyseposition> proben = new ArrayList<AtlAnalyseposition>();
        for (AtlAnalyseposition pos : probe.getAtlAnalysepositionen()) {
            if (!pos.getAtlParameter().equals(param)) continue;
            proben.add(pos);
        }
        return proben;
    }

    public static List getAnalysepositionen(AtlParameter param, AtlEinheiten einh, AtlProbepkt pkt, Date beginDate, Date endDate, String analyseVon) {
        List proben;
        AUIKataster.debugOutput("Suche (HQL): p:" + param + ", e:" + einh + ", pkt:" + pkt + ", bD:" + beginDate + ", eD:" + endDate + ", aV:'" + analyseVon + "'", "AtlAnalyseposition");
        String paramID = param.getOrdnungsbegriff();
        Integer einhID = einh.getId();
        Integer pktID = pkt.getObjektid();
        String query = "from AtlAnalyseposition pos where pos.atlParameter = ? and pos.atlEinheiten = ? and pos.atlProbenahmen.atlProbepkt = ? and pos.atlProbenahmen.datumDerEntnahme >= ? and pos.atlProbenahmen.datumDerEntnahme <= ? ";
        if (analyseVon != null && !analyseVon.equals("")) {
            query = query + "and pos.analyseVon like ? ";
        }
        query = query + "order by pos.atlProbenahmen.datumDerEntnahme";
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = analyseVon != null && !analyseVon.equals("") ? session.createQuery(query).setEntity(0, (Object)param).setEntity(1, (Object)einh).setEntity(2, (Object)pkt).setDate(3, beginDate).setDate(4, endDate).setString(5, analyseVon).list() : session.createQuery(query).setEntity(0, (Object)param).setEntity(1, (Object)einh).setEntity(2, (Object)pkt).setDate(3, beginDate).setDate(4, endDate).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlAnalysepositionen)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return proben;
    }

    public static List getAnalysepos(AtlParameter param, Integer pkt) {
        List proben;
        AUIKataster.debugOutput("Suche (HQL): p:" + param + " pkt:" + pkt, "AtlAnalyseposition");
        String query = "from AtlAnalyseposition as pos where pos.atlParameter = ? ";
        if (pkt != null) {
            query = query + "and pos.atlProbenahmen.atlProbepkt.objektid = '" + pkt + "' ";
        } else {
            AUIKataster.debugOutput("objektid = null", "getAnalysepos");
        }
        query = query + "order by pos.atlProbenahmen.datumDerEntnahme";
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = session.createQuery(query).setEntity(0, (Object)param).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlAnalysepositionen)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return proben;
    }

    public static List getSielhautpos(String param, Integer pkt, Date anfang, Date ende) {
        AUIKataster.debugOutput("Suche (HQL): p:" + param + ", pkt:" + pkt + ", bD:" + anfang + ", eD:" + ende + ", aV:'", "AtlAnalyseposition");
        List proben = null;
        String query = "from AtlAnalyseposition pos where pos.atlProbenahmen.datumDerEntnahme >= ? and pos.atlProbenahmen.datumDerEntnahme <= ? ";
        if (pkt != null) {
            query = query + "and pos.atlProbenahmen.atlProbepkt.objektid = '" + pkt + "' ";
        } else {
            AUIKataster.debugOutput("objektid = null", "getSielhautpos");
        }
        if (param != null) {
            query = query + "and pos.atlParameter.bezeichnung = '" + param + "' ";
        } else {
            AUIKataster.debugOutput("param = null", "getSielhautpos");
        }
        query = query + "order by pos.atlProbenahmen.datumDerEntnahme";
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = session.createQuery(query).setDate(0, anfang).setDate(1, ende).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlAnalysepositionen)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return proben;
    }

    public static String[] getAnalysierer() {
        List proben = null;
        String query = "select distinct analyseVon from AtlAnalyseposition";
        try {
            Session session = HibernateSessionFactory.currentSession();
            proben = session.createQuery(query).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler (AtlAnalysepositionen)", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        String[] tmp = new String[proben.size()];
        tmp = proben.toArray(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAnalyseposition(AtlAnalyseposition pos) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)pos);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "AtlAnalyseposition.saveAnalyseposition", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }
}

