/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import de.bielefeld.umweltamt.aui.AUIKataster;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SettingsManager {
    private Properties instanceSettings = new Properties();
    private Properties appSettings;
    private static SettingsManager _instance;

    private SettingsManager() {
        this.initAppSettings();
    }

    public static synchronized SettingsManager getInstance() {
        if (_instance == null) {
            _instance = new SettingsManager();
        }
        return _instance;
    }

    private void initAppSettings() {
        Properties defaults = new Properties();
        defaults.setProperty("auik.prefs.res_x", "700");
        defaults.setProperty("auik.prefs.res_y", "525");
        defaults.setProperty("auik.prefs.maximized", "false");
        defaults.setProperty("auik.prefs.save_size", "true");
        defaults.setProperty("auik.system.spath_fotos", "X:/Applikationen/Anlagenkataster/SielhautBearbeiten/fotos/");
        defaults.setProperty("auik.system.spath_karten", "X:/Applikationen/Anlagenkataster/SielhautBearbeiten/karten/");
        defaults.setProperty("auik.system.module", "BasisStandortSuchen, BasisStandortNeu, KlaerschlammRohschlammproben, KlaerschlammFaulschlammproben, LaborProbeSuchen, KlaerschlammAuswertung, LaborIcpImport, EinleiterAnh50Auswertung, EinleiterAnh49Auswertung, EinleiterBrennwertAuswertung, EinleiterSuevkanAuswertung, EinleiterAnh40Auswertung, EinleiterAnh56Auswertung, VawsHerstellernummerSuchen, VawsKontrollenAuswertung, VawsVerwaltungsverfAuswertung, BasisBetreiberSuchen, BasisBetreiberNeu, BasisObjektBearbeiten, SielhautBearbeiten, SielhautImport, AnalyseImport");
        defaults.setProperty("auik.prefs.status_time", "40");
        defaults.setProperty("auik.prefs.sielhaut_labor", "HBICON");
        defaults.setProperty("auik.birt.enginepath", "X:\\Applikationen\\Anlagenkataster\\auik\\birt\\birt-runtime-2_3_2\\ReportEngine\\");
        defaults.setProperty("auik.birt.reportpath", "X:\\Applikationen\\Anlagenkataster\\auik\\birt\\designs\\");
        defaults.setProperty("auik.gis.programmpath", "C:\\appz\\qgis\\bin\\qgis.exe\\");
        defaults.setProperty("auik.gis.projectpath", "D:\\\\data\\qgis\\MyProject.qgs");
        this.appSettings = new Properties(defaults);
        try {
            this.appSettings.load(new FileInputStream("auik.properties"));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            AUIKataster.debugOutput("Fehler beim laden der Benutzer-Einstellungen", "SettingsManager.initAppSettings");
            e.printStackTrace();
        }
    }

    public void saveSettings() {
        try {
            this.appSettings.store(new FileOutputStream("auik.properties"), "Allgemeine Einstellungen f\u00fcr AUI-Kataster v0.3");
        }
        catch (IOException e) {
            AUIKataster.debugOutput("Konnte Einstellungen nicht speichern!", "SettingsManager.saveSettings");
            e.printStackTrace();
        }
    }

    public void setSetting(String setting, String value, boolean persist) {
        if (persist) {
            this.appSettings.setProperty(setting, value);
        } else {
            this.instanceSettings.setProperty(setting, value);
        }
    }

    public void setSetting(String setting, int value, boolean persist) {
        this.setSetting(setting, Integer.toString(value), persist);
    }

    public void setSetting(String setting, boolean value, boolean persist) {
        this.setSetting(setting, Boolean.toString(value), persist);
    }

    public String getSetting(String setting) {
        if (this.instanceSettings.containsKey(setting)) {
            return this.instanceSettings.getProperty(setting);
        }
        return this.appSettings.getProperty(setting);
    }

    public int getIntSetting(String setting) {
        String tmp = this.getSetting(setting);
        if (tmp != null) {
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public boolean getBoolSetting(String setting) {
        String tmp = this.getSetting(setting);
        if (tmp != null) {
            return Boolean.valueOf(tmp);
        }
        return false;
    }

    public void removeSetting(String setting) {
        if (this.instanceSettings.containsKey(setting)) {
            this.instanceSettings.remove(setting);
        }
        if (this.appSettings.containsKey(setting)) {
            this.appSettings.remove(setting);
        }
    }
}

