/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.SettingsManager;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;

public class ReportManager {
    private static ReportManager _instance;
    private EngineConfig config;
    private IReportEngine engine;
    private HTMLRenderOption options;
    private String engineHome;
    private String reportHome;
    private String fotoPath;
    private String mapPath;

    private ReportManager(String engineHome, String reportHome, String fotoPath, String mapPath) {
        this.engineHome = engineHome;
        this.reportHome = reportHome;
        this.fotoPath = fotoPath;
        this.mapPath = mapPath;
        this.initBirt();
    }

    public File runReport(String Name) throws EngineException {
        File pdfFile;
        try {
            pdfFile = File.createTempFile(Name, ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException("Konnte tempor\u00e4re PDF-Datei nicht speichern!", e);
        }
        pdfFile.deleteOnExit();
        this.runReport(pdfFile, Name);
        return pdfFile;
    }

    public File runReport(String Name, Integer Id, String Bezeichnung) throws EngineException {
        File pdfFile;
        try {
            pdfFile = File.createTempFile(Name + Id, ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException("Konnte tempor\u00e4re PDF-Datei nicht speichern!", e);
        }
        pdfFile.deleteOnExit();
        this.runReport(pdfFile, Name, Id, Bezeichnung);
        return pdfFile;
    }

    public File runReport(String Name, Integer ObjektId, String Betreiber, String Standort, String Art) throws EngineException {
        File pdfFile;
        try {
            pdfFile = File.createTempFile(Name + ObjektId, ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException("Konnte tempor\u00e4re PDF-Datei nicht speichern!", e);
        }
        pdfFile.deleteOnExit();
        this.runReport(pdfFile, Name, ObjektId, Betreiber, Standort, Art);
        return pdfFile;
    }

    public File runReport(String Name, String art, Integer BehaelterId, String Betreiber, String Standort) throws EngineException {
        File pdfFile;
        try {
            pdfFile = File.createTempFile(Name + BehaelterId, ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException("Konnte tempor\u00e4re PDF-Datei nicht speichern!", e);
        }
        pdfFile.deleteOnExit();
        this.runReport(pdfFile, art, Name, BehaelterId, Betreiber, Standort);
        return pdfFile;
    }

    public File runReport(Integer StandortId, String Standort, String Name) throws EngineException {
        File pdfFile;
        try {
            pdfFile = File.createTempFile(Name + StandortId, ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException("Konnte tempor\u00e4re PDF-Datei nicht speichern!", e);
        }
        pdfFile.deleteOnExit();
        this.runReport(pdfFile, StandortId, Standort, Name);
        return pdfFile;
    }

    protected void initBirt() {
        this.config = null;
        this.engine = null;
        try {
            this.config = new EngineConfig();
            this.config.setEngineHome(this.engineHome);
            this.config.setLogConfig(null, Level.OFF);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Platform.startup((PlatformConfig)this.config);
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        this.engine = factory.createReportEngine(this.config);
        this.engine.changeLogLevel(Level.OFF);
    }

    public void startReportWorker(final String Name, Component focusComp) throws EngineException {
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){
            File pdfFile;

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    this.pdfFile = ReportManager.this.runReport(Name);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                AuikUtils.spawnFileProg(this.pdfFile);
            }
        };
        worker.start();
    }

    public void startReportWorker(final String Name, final Integer Id, final String HaltungsNr, Component focusComp) throws EngineException {
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){
            File pdfFile;

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    this.pdfFile = ReportManager.this.runReport(Name, Id, HaltungsNr);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                AuikUtils.spawnFileProg(this.pdfFile);
            }
        };
        worker.start();
    }

    public void startReportWorker(final String Name, final Integer ObjektId, final String Betreiber, final String Standort, final String Art, Component focusComp) {
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){
            File pdfFile;

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    this.pdfFile = ReportManager.this.runReport(Name, ObjektId, Betreiber, Standort, Art);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                AuikUtils.spawnFileProg(this.pdfFile);
            }
        };
        worker.start();
    }

    public void startReportWorker(final String Name, final String Standort, final Integer StandortId, Component focusComp) {
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){
            File pdfFile;

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    this.pdfFile = ReportManager.this.runReport(StandortId, Standort, Name);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                AuikUtils.spawnFileProg(this.pdfFile);
            }
        };
        worker.start();
    }

    public void startReportWorker(final String Name, final Integer BehaelterId, final String Betreiber, final String Standort, Component focusComp, final String art) {
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){
            File pdfFile;

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    this.pdfFile = ReportManager.this.runReport(Name, art, BehaelterId, Betreiber, Standort);
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                AuikUtils.spawnFileProg(this.pdfFile);
            }
        };
        worker.start();
    }

    public void runReport(File pdffile, String Name) throws EngineException {
        if (Name == null) {
            System.out.println("DEBUG::runReport Error: Id Name oder HaltungsNr nicht gesetzt!\n");
            System.out.println("\nName: " + Name);
        }
        if (this.config == null || this.engine == null || this.options == null) {
            this.initBirt();
        }
        IReportRunnable design = null;
        design = this.engine.openReportDesign(this.reportHome + Name + ".rptdesign");
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(design);
        task.validateParameters();
        this.options = new HTMLRenderOption();
        this.options.setEmbeddable(true);
        this.options.setOutputFileName(pdffile.getAbsolutePath());
        this.options.setOutputFormat("pdf");
        task.setRenderOption((IRenderOption)this.options);
        try {
            task.run();
            this.shutdownBirt();
        }
        catch (EngineException e1) {
            throw new RuntimeException("Fehler beim Durchf\u00fchren des BIRT-Reports!", e1);
        }
    }

    public void runReport(File pdffile, String Name, Integer Id, String Bezeichnung) throws EngineException {
        if (Id == null || Name == null || Bezeichnung == null) {
            System.out.println("DEBUG::runReport Error: Id Name oder HaltungsNr nicht gesetzt!\n");
            System.out.println("Id: " + Id);
            System.out.println("\nName: " + Name);
            System.out.println("\nHaltungsNr: " + Bezeichnung);
        }
        if (this.config == null || this.engine == null || this.options == null) {
            this.initBirt();
        }
        IReportRunnable design = null;
        design = this.engine.openReportDesign(this.reportHome + Name + ".rptdesign");
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(design);
        task.setParameterValue("id", (Object)Id);
        if (Bezeichnung != null && new File(this.fotoPath + Bezeichnung + ".jpg").canRead()) {
            task.setParameterValue("foto", (Object)new String(this.fotoPath + Bezeichnung + ".jpg"));
        } else {
            task.setParameterValue("foto", (Object)new String(this.fotoPath + "kein_foto.jpg"));
        }
        if (Bezeichnung != null && new File(this.mapPath + Bezeichnung + ".jpg").canRead()) {
            task.setParameterValue("karte", (Object)new String(this.mapPath + Bezeichnung + ".jpg"));
        } else {
            task.setParameterValue("karte", (Object)new String(this.mapPath + "keine_karte.jpg"));
        }
        task.validateParameters();
        this.options = new HTMLRenderOption();
        this.options.setEmbeddable(true);
        this.options.setOutputFileName(pdffile.getAbsolutePath());
        this.options.setOutputFormat("pdf");
        task.setRenderOption((IRenderOption)this.options);
        try {
            task.run();
            this.shutdownBirt();
        }
        catch (EngineException e1) {
            throw new RuntimeException("Fehler beim Durchf\u00fchren des BIRT-Reports!", e1);
        }
    }

    public void runReport(File pdffile, Integer StandortId, String Standort, String Name) throws EngineException {
        if (this.config == null || this.engine == null || this.options == null) {
            this.initBirt();
        }
        IReportRunnable design = null;
        try {
            design = this.engine.openReportDesign(this.reportHome + Name + ".rptdesign");
        }
        catch (EngineException e1) {
            AUIKataster.debugOutput("Fehler: " + (Object)((Object)e1));
        }
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(design);
        task.setParameterValue("StandortID", (Object)StandortId);
        task.setParameterValue("Standort", (Object)Standort);
        task.validateParameters();
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEmbeddable(true);
        options.setOutputFileName(pdffile.getAbsolutePath());
        options.setOutputFormat("pdf");
        task.setRenderOption((IRenderOption)options);
        try {
            task.run();
            this.shutdownBirt();
        }
        catch (EngineException e1) {
            throw new RuntimeException("Fehler beim Durchf\u00fchren des BIRT-Reports!", e1);
        }
    }

    public void runReport(File pdffile, String Name, Integer ObjektId, String Betreiber, String Standort, String Art) throws EngineException {
        if (this.config == null || this.engine == null || this.options == null) {
            this.initBirt();
        }
        IReportRunnable design = null;
        design = this.engine.openReportDesign(this.reportHome + Name + ".rptdesign");
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(design);
        task.setParameterValue("ObjektId", (Object)ObjektId);
        task.setParameterValue("Betreiber", (Object)Betreiber);
        task.setParameterValue("Standort", (Object)Standort);
        task.setParameterValue("Art", (Object)Art);
        task.validateParameters();
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEmbeddable(true);
        options.setOutputFileName(pdffile.getAbsolutePath());
        options.setOutputFormat("pdf");
        task.setRenderOption((IRenderOption)options);
        try {
            task.run();
            this.shutdownBirt();
        }
        catch (EngineException e1) {
            throw new RuntimeException("Fehler beim Durchf\u00fchren des BIRT-Reports!", e1);
        }
    }

    public void runReport(File pdffile, String art, String Name, Integer BehaelterId, String Betreiber, String Standort) throws EngineException {
        if (this.config == null || this.engine == null || this.options == null) {
            this.initBirt();
        }
        IReportRunnable design = null;
        design = this.engine.openReportDesign(this.reportHome + Name + ".rptdesign");
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(design);
        task.setParameterValue("BehaelterId", (Object)BehaelterId);
        task.setParameterValue("Betreiber", (Object)Betreiber);
        task.setParameterValue("Standort", (Object)Standort);
        task.setParameterValue("Objektart", (Object)art);
        task.validateParameters();
        HTMLRenderOption options = new HTMLRenderOption();
        options.setEmbeddable(true);
        options.setOutputFileName(pdffile.getAbsolutePath());
        options.setOutputFormat("pdf");
        task.setRenderOption((IRenderOption)options);
        try {
            task.run();
            this.shutdownBirt();
        }
        catch (EngineException e1) {
            throw new RuntimeException("Fehler beim Durchf\u00fchren des BIRT-Reports!", e1);
        }
    }

    public static synchronized ReportManager getInstance() {
        if (_instance == null) {
            String engineHome = SettingsManager.getInstance().getSetting("auik.birt.enginepath");
            String reportHome = SettingsManager.getInstance().getSetting("auik.birt.reportpath");
            String fotoPath = SettingsManager.getInstance().getSetting("auik.system.spath_fotos");
            String mapPath = SettingsManager.getInstance().getSetting("auik.system.spath_karten");
            _instance = new ReportManager(engineHome, reportHome, fotoPath, mapPath);
        }
        return _instance;
    }

    public void shutdownBirt() {
        if (this.engine != null) {
            this.engine.destroy();
            AUIKataster.debugOutput("Engine zerst\u00f6rt!");
        }
        this.engine = null;
        this.config = null;
        this.options = null;
        Runtime.getRuntime().gc();
    }

    protected void finalize() {
        this.shutdownBirt();
    }
}

