/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import com.jgoodies.forms.factories.Borders;
import com.l2fprod.common.swing.JButtonBar;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.Modul;
import de.bielefeld.umweltamt.aui.SettingsManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class ModulManager {
    private HauptFrame frame;
    private SettingsManager settings;
    private SortedMap categories = new TreeMap();
    private Hashtable module = new Hashtable();
    private Hashtable modulButtons = new Hashtable();
    private String currentCategory = null;
    private String currentModul = null;
    private List modulHistory = new ArrayList(15);
    private int currentIndex = 0;

    public ModulManager(HauptFrame frame, SettingsManager settings) {
        this.frame = frame;
        this.settings = settings;
    }

    public void loadModule() {
        String tmp = this.settings.getSetting("auik.system.module");
        if (tmp != null && tmp.length() != 0) {
            String[] modules = tmp.split(",");
            for (int i = 0; i < modules.length; ++i) {
                String modul = modules[i].trim();
                this.loadModul(modul);
            }
        }
    }

    private void loadModul(String modulName) {
        Modul m = null;
        try {
            Object mOb = Class.forName("de.bielefeld.umweltamt.aui.module." + modulName).newInstance();
            if (mOb instanceof Modul) {
                m = (Modul)mOb;
            }
        }
        catch (Exception e) {
            m = null;
        }
        if (m != null) {
            this.addModul(m);
        }
    }

    private void addModul(Modul m) {
        String cat;
        AUIKataster.debugOutput("F\u00fcge Modul '" + m.getName() + "' (" + m.getIdentifier() + ") hinzu...", "ModulManager.addModul");
        boolean isFirst = false;
        m.setManager(this);
        m.setFrame(this.frame);
        if (this.module.isEmpty()) {
            isFirst = true;
        }
        if (this.getCategory(cat = m.getCategory()) == null) {
            this.addCategory(cat);
        }
        ModulKategorie mk = this.getCategory(cat);
        mk.addModul(m);
        JToggleButton button = new JToggleButton("<html><center>" + m.getName() + "</center></html>", m.getIcon());
        button.setAlignmentX(0.5f);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setSelected(isFirst);
        button.setActionCommand(m.getIdentifier());
        button.setToolTipText(m.getName());
        button.addActionListener(this.frame.getButtonListener());
        JButtonBar catToolBar = mk.getButtonBar();
        catToolBar.add((Component)button);
        JScrollPane mScroller = new JScrollPane(m.getPanel());
        mScroller.setBorder(BorderFactory.createEmptyBorder());
        mScroller.getVerticalScrollBar().setUnitIncrement(20);
        this.frame.getRightCardPanel().add((Component)mScroller, m.getIdentifier());
        this.module.put(m.getIdentifier(), m);
        this.modulButtons.put(m.getIdentifier(), button);
        if (isFirst) {
            this.switchModul(m.getIdentifier(), true);
        }
    }

    private void addCategory(String title) {
        if (this.categories.isEmpty()) {
            this.frame.getViewMenuButton().setText(title);
            this.currentCategory = title;
        }
        ModulKategorie mk = new ModulKategorie(title);
        this.categories.put(mk.getName(), mk);
        this.frame.getLeftCardPanel().add((Component)mk.getButtonBar(), mk.getName());
        this.rebuildMenu();
    }

    private void rebuildMenu() {
        this.frame.getViewMenu().removeAll();
        for (String title : this.categories.keySet()) {
            JMenuItem catItem = new JMenuItem(title);
            catItem.setActionCommand(title);
            catItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModulManager.this.switchCategory(e.getActionCommand(), true);
                }
            });
            this.frame.getViewMenu().add(catItem);
        }
    }

    private ModulKategorie getCategory(String title) {
        if (this.categories.containsKey(title)) {
            return (ModulKategorie)this.categories.get(title);
        }
        return null;
    }

    public void switchModul(String identifier) {
        this.switchModul(identifier, true);
    }

    private void switchModul(String identifier, boolean addToHistory) {
        Enumeration e1 = this.module.elements();
        while (e1.hasMoreElements()) {
            JToggleButton button;
            Modul m = (Modul)e1.nextElement();
            if (m.getIdentifier().equals(identifier)) {
                button = (JToggleButton)this.modulButtons.get(identifier);
                button.setSelected(true);
                this.frame.getRightFrame().setTitle(m.getName());
                this.currentModul = identifier;
                if (addToHistory) {
                    if (this.modulHistory.size() > 0 && this.currentIndex < this.modulHistory.size() - 1) {
                        this.modulHistory.subList(this.currentIndex + 1, this.modulHistory.size()).clear();
                    }
                    String lastModul = "";
                    if (this.modulHistory.size() > 0) {
                        lastModul = (String)this.modulHistory.get(this.modulHistory.size() - 1);
                    }
                    if (!lastModul.equals(this.currentModul)) {
                        this.modulHistory.add(this.currentModul);
                    }
                    this.currentIndex = this.modulHistory.size() - 1;
                }
                m.show();
                CardLayout cl = (CardLayout)this.frame.getRightCardPanel().getLayout();
                cl.show(this.frame.getRightCardPanel(), identifier);
                this.switchCategory(m.getCategory(), false);
                continue;
            }
            button = (JToggleButton)this.modulButtons.get(m.getIdentifier());
            button.setSelected(false);
            m.hide();
        }
        if (this.currentIndex > 0) {
            this.frame.getModulBackButton().setEnabled(true);
        } else {
            this.frame.getModulBackButton().setEnabled(false);
        }
        if (this.currentIndex < this.modulHistory.size() - 1) {
            this.frame.getModulFwdButton().setEnabled(true);
        } else {
            this.frame.getModulFwdButton().setEnabled(false);
        }
        AUIKataster.debugOutput("Switched to: " + this.currentModul + ", Index: " + this.currentIndex, "ModulManager.switchModul");
        String tmpHist = "History: ";
        for (int i = 0; i < this.modulHistory.size(); ++i) {
            if (i != 0) {
                tmpHist = tmpHist + ", ";
            }
            String mod = (String)this.modulHistory.get(i);
            if (i == this.currentIndex) {
                mod = ">" + mod + "<";
            }
            tmpHist = tmpHist + mod;
        }
        AUIKataster.debugOutput(tmpHist, "ModulManager.switchModul");
        this.frame.clearStatus();
    }

    public Modul getCurrentModul() {
        return (Modul)this.module.get(this.currentModul);
    }

    public void back() {
        if (this.currentIndex > 0) {
            int lastIndex = this.currentIndex - 1;
            String lastModul = (String)this.modulHistory.get(lastIndex);
            this.currentIndex = lastIndex;
            this.switchModul(lastModul, false);
        }
    }

    public void forward() {
        if (this.currentIndex < this.modulHistory.size() - 1) {
            int nextIndex = this.currentIndex + 1;
            String nextModul = (String)this.modulHistory.get(nextIndex);
            this.currentIndex = nextIndex;
            this.switchModul(nextModul, false);
        }
    }

    private void switchCategory(String title, boolean switchToFirstMask) {
        if (!title.equals(this.currentCategory)) {
            CardLayout cl = (CardLayout)this.frame.getLeftCardPanel().getLayout();
            cl.show(this.frame.getLeftCardPanel(), title);
            this.frame.getViewMenuButton().setText(title);
            this.currentCategory = title;
            if (switchToFirstMask) {
                ModulKategorie mk = this.getCategory(title);
                this.switchModul(mk.getFirstModul().getIdentifier());
            }
        }
    }

    public SettingsManager getSettingsManager() {
        return this.settings;
    }

    private class ModulKategorie {
        private String name;
        private JButtonBar buttonBar;
        private List module;

        public ModulKategorie(String name) {
            this.name = name;
            this.module = new ArrayList();
            this.buttonBar = new JButtonBar(1);
            this.buttonBar.setBorder(Borders.EMPTY_BORDER);
            this.buttonBar.setBackground(ModulManager.this.frame.getLeftFrame().getBackground());
        }

        public String getName() {
            return this.name;
        }

        public JButtonBar getButtonBar() {
            return this.buttonBar;
        }

        public List getModule() {
            return this.module;
        }

        public Modul getFirstModul() {
            if (this.module.size() > 0) {
                return (Modul)this.module.get(0);
            }
            return null;
        }

        public void addModul(Modul m) {
            if (!m.getCategory().equals(this.name)) {
                throw new IllegalArgumentException("Dieses Modul geh\u00f6rt nicht in diese Kategorie!");
            }
            this.module.add(m);
        }
    }
}

