/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import de.bielefeld.umweltamt.aui.AUIKataster;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.exception.JDBCConnectionException;

public class HibernateSessionFactory {
    private static String CONFIG_FILE_LOCATION = System.getProperty("auik.hibernate.config", "/hibernate.cfg.xml");
    private static final ThreadLocal threadLocal = new ThreadLocal();
    private static Configuration cfg = new Configuration();
    private static SessionFactory sessionFactory;
    private static String DB_USER;
    private static String DB_PASS;
    private static String DB_URL;
    private static String DB_Driver;
    private static String DB_Dialect;

    public static Session currentSession() throws HibernateException {
        Session session = (Session)threadLocal.get();
        if (session == null) {
            if (sessionFactory == null) {
                try {
                    cfg.setProperty("hibernate.connection.username", DB_USER);
                    cfg.setProperty("hibernate.connection.password", DB_PASS);
                    cfg.setProperty("hibernate.connection.url", "jdbc:informix-sqli://recos14:1534/auik_ibb:INFORMIXSERVER=uschi");
                    cfg.configure(CONFIG_FILE_LOCATION);
                    sessionFactory = cfg.buildSessionFactory();
                }
                catch (Exception e) {
                    System.err.println("%%%% Error Creating SessionFactory %%%%");
                    e.printStackTrace();
                }
            }
            session = sessionFactory.openSession();
            threadLocal.set(session);
            AUIKataster.debugOutput("Neue Session begonnen!", "HibernateSessionFactory");
        }
        return session;
    }

    public static void closeSession() {
        Session session = (Session)threadLocal.get();
        threadLocal.set(null);
        if (session != null) {
            try {
                session.close();
                AUIKataster.debugOutput("Session geschlossen!", "HibernateSessionFactory");
            }
            catch (HibernateException e) {
                AUIKataster.handleDBException(e, "HibernateSessionFactory.closeSession", false);
            }
        }
    }

    public static void setDBUrl(String url) {
        DB_URL = url;
    }

    public static String getDBUrl() {
        return DB_URL;
    }

    public static String getDBDriver() {
        return DB_Driver;
    }

    public static void setDBDriver(String driver) {
        DB_Driver = driver;
    }

    public static String getDBDialect() {
        return DB_Dialect;
    }

    public static void setDBDialect(String dialect) {
        DB_Dialect = dialect;
    }

    public static void setDBData(String user, String pass) {
        DB_USER = user;
        DB_PASS = pass;
        HibernateSessionFactory.closeSession();
        sessionFactory = null;
        cfg = new Configuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkCredentials(String user, String pass) throws HibernateException {
        boolean tmp;
        block6: {
            HibernateSessionFactory.setDBData(user, pass);
            tmp = false;
            try {
                Session session = HibernateSessionFactory.currentSession();
                List test = session.createSQLQuery("select strasse from basis_strassen where id=5").list();
                tmp = true;
                AUIKataster.debugOutput(test.toString(), "checkCredentials");
            }
            catch (HibernateException e) {
                if (((Object)((Object)e)).getClass().equals(JDBCConnectionException.class)) {
                    tmp = false;
                    HibernateSessionFactory.setDBData("", "");
                    break block6;
                }
                throw e;
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return tmp;
    }

    private HibernateSessionFactory() {
    }

    static {
        DB_USER = "";
        DB_PASS = "";
        DB_URL = "";
        DB_Driver = "";
        DB_Dialect = "";
    }
}

