/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.HeaderStyle;
import com.jgoodies.plaf.Options;
import com.jgoodies.uif_lite.component.Factory;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.ModulManager;
import de.bielefeld.umweltamt.aui.SettingsManager;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.GradientPanel;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.hibernate.HibernateException;

public class HauptFrame
extends JFrame {
    public static final Color ERROR_COLOR = new Color(200, 0, 0);
    public static final Color SUCCESS_COLOR = new Color(0, 128, 0);
    protected static final Color NORMAL_COLOR = Color.BLACK;
    protected static final int FILE_OPEN = 1;
    protected static final int FILE_SAVE = 2;
    private JPanel jContentPane = null;
    private ActionListener buttonListener = null;
    private Action closeAction = null;
    private JFileChooser fileChooser = null;
    private JMenuBar hauptMenue = null;
    private JMenu fileMenu = null;
    private JMenuItem settingsMenuItem = null;
    private JMenuItem exitMenuItem = null;
    private JMenu helpMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem DokuItem = null;
    private JPanel titlePanel = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JSplitPane splitPane = null;
    private SimpleInternalFrame leftFrame = null;
    private JScrollPane leftScroller = null;
    private JPanel leftCardPanel = null;
    private SimpleInternalFrame rightFrame = null;
    private JPanel rightCardPanel = null;
    private JPopupMenu viewMenu = null;
    private JToolBar viewMenuBar = null;
    private JButton viewMenuButton = null;
    private JToolBar modulBar = null;
    private JButton modulBackButton = null;
    private JButton modulFwdButton = null;
    private JButton qgis = null;
    private ModulManager manager;
    private SettingsManager settings;
    private Timer clearStatusTimer;

    public HauptFrame(SettingsManager settings) {
        this.settings = settings;
        this.initialize();
    }

    private void initialize() {
        try {
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setGlobalFontSizeHints((FontSizeHints)FontSizeHints.MIXED);
            Options.setUseSystemFonts((boolean)true);
            UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
        }
        catch (Exception e) {
            AUIKataster.debugOutput("Konnte Look & Feel nicht \u00e4ndern!", "HauptFrame.initialize");
        }
        this.setJMenuBar(this.getHauptMenue());
        this.setSize(this.settings.getIntSetting("auik.prefs.res_x"), this.settings.getIntSetting("auik.prefs.res_y"));
        if (this.settings.getBoolSetting("auik.prefs.maximized")) {
            this.setExtendedState(6);
        }
        this.setContentPane(this.getJContentPane());
        ImageIcon icon = (ImageIcon)AuikUtils.getIcon(16, "uaicon16.png", "Umweltamt");
        this.setIconImage(icon.getImage());
        this.setTitle("AUI-Kataster");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HauptFrame.this.close();
            }
        });
        this.locateOnScreen(this);
        this.clearStatusTimer = new Timer(this.settings.getIntSetting("auik.prefs.status_time") * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HauptFrame.this.clearStatus();
            }
        });
        this.clearStatusTimer.setRepeats(false);
        String db = this.settings.getSetting("auik.system.dburl");
        if (db != null && !db.equals("")) {
            HibernateSessionFactory.setDBUrl(db);
        }
        if (this.askForDBCredentials()) {
            this.manager = new ModulManager(this, this.settings);
            this.manager.loadModule();
            this.setVisible(true);
        } else {
            this.close();
        }
    }

    private boolean askForDBCredentials() {
        BenutzerDatenDialog benutzerDialog = new BenutzerDatenDialog(this);
        this.locateOnScreen(benutzerDialog);
        return benutzerDialog.loginSuccessful();
    }

    public Action getCloseAction() {
        if (this.closeAction == null) {
            this.closeAction = new AbstractAction("Beenden", AuikUtils.getIcon(32, "exit.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.close();
                }
            };
            this.closeAction.putValue("ShortDescription", "Beendet das Programm");
            this.closeAction.putValue("MnemonicKey", new Integer(66));
            this.closeAction.putValue("SmallIcon", AuikUtils.getIcon(16, "exit.png"));
        }
        return this.closeAction;
    }

    protected ActionListener getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.manager.switchModul(e.getActionCommand());
                }
            };
        }
        return this.buttonListener;
    }

    public JPopupMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JPopupMenu();
        }
        return this.viewMenu;
    }

    private JToolBar getViewMenuBar() {
        if (this.viewMenuBar == null) {
            this.viewMenuBar = new JToolBar();
            this.viewMenuBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.viewMenuBar.setFloatable(false);
            this.viewMenuBar.setOpaque(false);
            this.viewMenuBar.add(this.getViewMenuButton());
        }
        return this.viewMenuBar;
    }

    public JButton getViewMenuButton() {
        if (this.viewMenuButton == null) {
            this.viewMenuButton = new JButton("", AuikUtils.getIcon(16, "view_menu.gif", "Kategorien"));
            this.viewMenuButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Point np = SwingUtilities.convertPoint(HauptFrame.this.getLeftFrame(), 0, 0, HauptFrame.this.viewMenuButton);
                    HauptFrame.this.getViewMenu().show(HauptFrame.this.viewMenuButton, np.x, HauptFrame.this.viewMenuButton.getHeight());
                }
            });
            this.viewMenuButton.setForeground(this.getLeftFrame().getTextForeground(true));
            this.viewMenuButton.setOpaque(false);
            this.viewMenuButton.setHorizontalTextPosition(10);
            this.viewMenuButton.setToolTipText("Hier klicken, um die Kategorie zu wechseln");
        }
        return this.viewMenuButton;
    }

    private JToolBar getModulBar() {
        if (this.modulBar == null) {
            this.modulBar = new JToolBar();
            this.modulBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.modulBar.setFloatable(false);
            this.modulBar.setOpaque(false);
            this.modulBar.add(this.getQgis());
            this.modulBar.add(this.getModulBackButton());
            this.modulBar.add(this.getModulFwdButton());
        }
        return this.modulBar;
    }

    protected JButton getModulBackButton() {
        if (this.modulBackButton == null) {
            String desc = "Zur\u00fcck";
            this.modulBackButton = new JButton(AuikUtils.getIcon(16, "back.png", desc));
            this.modulBackButton.setToolTipText(desc);
            this.modulBackButton.setForeground(this.getRightFrame().getTextForeground(true));
            this.modulBackButton.setOpaque(false);
            this.modulBackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.manager.back();
                }
            });
            this.modulBackButton.setEnabled(false);
        }
        return this.modulBackButton;
    }

    protected JButton getModulFwdButton() {
        if (this.modulFwdButton == null) {
            String desc = "Vor";
            this.modulFwdButton = new JButton(AuikUtils.getIcon(16, "forward.png", desc));
            this.modulFwdButton.setToolTipText(desc);
            this.modulFwdButton.setForeground(this.getRightFrame().getTextForeground(true));
            this.modulFwdButton.setOpaque(false);
            this.modulFwdButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.manager.forward();
                }
            });
            this.modulFwdButton.setEnabled(false);
        }
        return this.modulFwdButton;
    }

    private JButton getQgis() {
        if (this.qgis == null) {
            String desc = "in QGIS ausgew\u00e4hltes Objekt aufrufen";
            this.qgis = new JButton("GIS", AuikUtils.getIcon(16, "qgis.png", desc));
            this.qgis.setForeground(this.getRightFrame().getTextForeground(true));
            this.qgis.setOpaque(false);
            this.qgis.setToolTipText(desc);
            this.qgis.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.readClipboard();
                }
            });
        }
        return this.qgis;
    }

    public void locateOnScreen(Window win) {
        Dimension paneSize = win.getSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        win.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public void close() {
        this.dispose();
        if (this.manager != null && this.manager.getCurrentModul() != null) {
            this.manager.getCurrentModul().hide();
        }
        HibernateSessionFactory.closeSession();
        if ((this.getExtendedState() & 6) == 6) {
            this.settings.setSetting("auik.prefs.maximized", true, true);
        } else {
            this.settings.setSetting("auik.prefs.maximized", false, true);
            if (this.settings.getBoolSetting("auik.prefs.save_size")) {
                this.settings.setSetting("auik.prefs.res_x", this.getWidth(), true);
                this.settings.setSetting("auik.prefs.res_y", this.getHeight(), true);
            }
        }
        this.settings.saveSettings();
        AUIKataster.debugOutput("Programm beendet!", "HauptFrame.close");
        System.exit(0);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTitlePanel(), "North");
            this.jContentPane.add((Component)this.getSplitPane(), "Center");
            this.jContentPane.add((Component)this.getStatusPanel(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getHauptMenue() {
        if (this.hauptMenue == null) {
            this.hauptMenue = new JMenuBar();
            this.hauptMenue.add(this.getFileMenu());
            this.hauptMenue.add(this.getHelpMenu());
            this.hauptMenue.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        }
        return this.hauptMenue;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("Datei");
            this.fileMenu.setMnemonic(68);
            this.fileMenu.add(this.getSettingsMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Hilfe");
            this.helpMenu.setMnemonic(72);
            this.helpMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
            this.helpMenu.add(this.getAboutMenuItem());
            this.helpMenu.add(this.getDoku());
        }
        return this.helpMenu;
    }

    private JMenuItem getSettingsMenuItem() {
        if (this.settingsMenuItem == null) {
            this.settingsMenuItem = new JMenuItem();
            this.settingsMenuItem.setText("Einstellungen");
            this.settingsMenuItem.setMnemonic(69);
            this.settingsMenuItem.setEnabled(false);
        }
        return this.settingsMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem(this.getCloseAction());
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("Info");
            this.aboutMenuItem.setMnemonic(79);
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HauptFrame.this.showInfoMessage("<html><center><i>AUI-Kataster</i> v.0.3<br>Datenbank: <i>" + HibernateSessionFactory.getDBUrl() + "</i><br>" + "Debug-Modus: <i>" + "An" + "</i><br>" + "&copy;  2005  Umweltamt Bielefeld & David Klotz<br>" + "</center></html>", "Info \u00fcber's AUI-Kataster");
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getDoku() {
        if (this.DokuItem == null) {
            this.DokuItem = new JMenuItem();
            this.DokuItem.setText("Handbuch");
            this.DokuItem.setMnemonic(66);
            this.DokuItem.setEnabled(true);
            this.DokuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String[] cmdstart = new String[]{"cmd", "/c", "explorer", "X:\\Orga\\360\\360-3\\360-3-3\\Alle\\Datenbanken\\Bedienungsanleitung AUIK"};
                        Runtime.getRuntime().exec(cmdstart);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.DokuItem;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new GradientPanel((LayoutManager)new BorderLayout(), Color.WHITE);
            this.titlePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.titlePanel.add((Component)new JLabel(AuikUtils.getIcon(32, "uaicon32.png", "AUI-Kataster"), 10), "West");
            JLabel titleLabel = new JLabel("Anlagen- und Indirekteinleiter-Kataster", 11);
            titleLabel.setFont(new Font("SansSerif", 1, 18));
            this.titlePanel.add((Component)titleLabel, "Center");
        }
        return this.titlePanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusLabel = new JLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusLabel.setText("Willkommen im AUI-K");
            this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
            this.statusPanel.add((Component)this.statusLabel, "Center");
        }
        return this.statusPanel;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = Factory.createStrippedSplitPane(1, this.getLeftFrame(), this.getRightFrame(), 0.08f);
        }
        return this.splitPane;
    }

    protected SimpleInternalFrame getLeftFrame() {
        if (this.leftFrame == null) {
            this.leftFrame = new SimpleInternalFrame(" ");
            this.leftFrame.setMinimumSize(new Dimension(100, 0));
            this.leftFrame.setPreferredSize(this.leftFrame.getMinimumSize());
            this.leftFrame.setToolBar(this.getViewMenuBar());
            this.leftFrame.setContent(this.getLeftScroller());
        }
        return this.leftFrame;
    }

    protected SimpleInternalFrame getRightFrame() {
        if (this.rightFrame == null) {
            this.rightFrame = new SimpleInternalFrame(" ");
            this.rightFrame.setMinimumSize(new Dimension(250, 0));
            this.rightFrame.setToolBar(this.getModulBar());
            this.rightFrame.setContent(this.getRightCardPanel());
        }
        return this.rightFrame;
    }

    protected JPanel getRightCardPanel() {
        if (this.rightCardPanel == null) {
            this.rightCardPanel = new JPanel(new CardLayout());
        }
        return this.rightCardPanel;
    }

    private JScrollPane getLeftScroller() {
        if (this.leftScroller == null) {
            this.leftScroller = new JScrollPane(20, 31);
            this.leftScroller.setBorder(BorderFactory.createEmptyBorder());
            this.leftScroller.setViewportView(this.getLeftCardPanel());
        }
        return this.leftScroller;
    }

    protected JPanel getLeftCardPanel() {
        if (this.leftCardPanel == null) {
            this.leftCardPanel = new JPanel(new CardLayout());
        }
        return this.leftCardPanel;
    }

    public ModulManager getManager() {
        return this.manager;
    }

    public void changeStatus(String txt) {
        if (txt.equals("")) {
            this.clearStatus();
        } else {
            this.changeStatus(txt, NORMAL_COLOR);
        }
    }

    public void changeStatus(String txt, Color color) {
        this.statusLabel.setForeground(color);
        this.statusLabel.setText(txt);
        if (this.clearStatusTimer.isRunning()) {
            this.clearStatusTimer.restart();
        } else {
            this.clearStatusTimer.start();
        }
    }

    public void clearStatus() {
        this.statusLabel.setForeground(NORMAL_COLOR);
        this.statusLabel.setText(" ");
        this.clearStatusTimer.stop();
    }

    public void showErrorMessage(String msg) {
        this.showErrorMessage(msg, "Fehler");
    }

    public void showErrorMessage(String msg, String title) {
        JOptionPane.showMessageDialog(this.getRightFrame(), msg, title, 0);
    }

    public void showInfoMessage(String msg, String title) {
        JOptionPane.showMessageDialog(this.getRightFrame(), msg, title, 1);
    }

    public boolean showQuestion(String question) {
        return this.showQuestion(question, "Frage");
    }

    public boolean showQuestion(String question, String title) {
        boolean ret = false;
        int answer = JOptionPane.showConfirmDialog(this.getRightFrame(), question, title, 0);
        if (answer == 0) {
            ret = true;
        }
        return ret;
    }

    public File openFile() {
        return this.openOrSaveFile(null, null, 1);
    }

    public File openFile(String[] extensions) {
        return this.openOrSaveFile(null, extensions, 1);
    }

    public File saveFile() {
        return this.openOrSaveFile(null, null, 2);
    }

    public File saveFile(String[] extensions) {
        return this.openOrSaveFile(null, extensions, 2);
    }

    private File openOrSaveFile(File directory, String[] extensions, int openOrSave) {
        File tmp;
        String lastDir;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if (directory == null && (lastDir = this.manager.getSettingsManager().getSetting("auik.prefs.last_dir")) != null && (tmp = new File(lastDir)).isDirectory()) {
            directory = tmp;
        }
        this.fileChooser.setCurrentDirectory(directory);
        this.fileChooser.resetChoosableFileFilters();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                this.fileChooser.addChoosableFileFilter(AuikUtils.getExtensionFilter(extensions[i]));
            }
            if (extensions.length > 1) {
                this.fileChooser.addChoosableFileFilter(AuikUtils.getExtensionsFilter(extensions));
            }
        }
        int retVal = 1;
        if (openOrSave == 1) {
            retVal = this.fileChooser.showOpenDialog(this.getRightFrame());
        } else if (openOrSave == 2) {
            retVal = this.fileChooser.showSaveDialog(this.getRightFrame());
        }
        if (retVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.manager.getSettingsManager().setSetting("auik.prefs.last_dir", file.getParent(), true);
            return file;
        }
        return null;
    }

    private void readClipboard() {
        String tmp = null;
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferData = systemClipboard.getContents(null);
        for (DataFlavor dataFlavor : transferData.getTransferDataFlavors()) {
            Object content = null;
            try {
                content = transferData.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (content instanceof String) {
                tmp = content.toString();
            }
            if (tmp == null) continue;
            int index = tmp.indexOf("bezeichnung");
            if (index != -1) {
                String bezeichnung;
                AtlSielhaut sielhaut;
                char ersetzen = '\"';
                char leer = '\u0000';
                String tmp2 = tmp.replace(ersetzen, leer);
                int indexBez = tmp2.indexOf("bsb");
                if (indexBez == -1) {
                    indexBez = tmp2.indexOf("entgeb");
                }
                if ((sielhaut = AtlSielhaut.getSielhautByBez(bezeichnung = tmp2.substring(tmp2.indexOf("bezeichnung") + 13, indexBez - 1))) != null) {
                    AtlProbepkt probepunkt = AtlProbepkt.getSielhautProbepunkt(sielhaut);
                    this.manager.getSettingsManager().setSetting("auik.imc.edit_object", probepunkt.getBasisObjekt().getObjektid(), false);
                    this.manager.switchModul("m_sielhaut1");
                    this.changeStatus("Daten aus Zwischenablage ausgelesen", SUCCESS_COLOR);
                    break;
                }
                this.changeStatus("Zwischenablage enth\u00e4lt keine verwertbaren Daten", ERROR_COLOR);
                break;
            }
            this.changeStatus("Zwischenablage enth\u00e4lt keine verwertbaren Daten", ERROR_COLOR);
            break;
        }
        if (tmp == null) {
            this.changeStatus("Zwischenablage enth\u00e4lt keine verwertbaren Daten", ERROR_COLOR);
        }
    }

    private final class BenutzerDatenDialog
    extends JDialog {
        private JLabel textLabel;
        private JTextField benutzerFeld;
        private JPasswordField passwortFeld;
        private JButton loginButton;
        private String user;
        private String pw;
        private KeyEventDispatcher escListener;
        private boolean success;
        private boolean busy;

        public BenutzerDatenDialog(Frame owner) throws HeadlessException {
            super(owner, "Willkommen im AUI-Kataster", true);
            this.success = false;
            this.busy = false;
            this.initialize();
        }

        private void initialize() {
            this.escListener = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getKeyCode() == 27 && !BenutzerDatenDialog.this.busy) {
                        BenutzerDatenDialog.this.success = false;
                        BenutzerDatenDialog.this.close();
                    }
                    return false;
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.escListener);
            this.textLabel = new JLabel("<html>Bitte geben Sie ihren Benutzernamen und <br>ihr Passwort ein und klicken Sie auf \"Login\".</html>");
            this.benutzerFeld = new JTextField(10);
            if (HauptFrame.this.settings.getSetting("auik.prefs.lastuser") == null) {
                this.benutzerFeld.setText(System.getProperty("user.name"));
            } else {
                this.benutzerFeld.setText(HauptFrame.this.settings.getSetting("auik.prefs.lastuser"));
            }
            this.benutzerFeld.selectAll();
            this.passwortFeld = new JPasswordField(10);
            this.loginButton = new JButton("Login");
            this.benutzerFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BenutzerDatenDialog.this.passwortFeld.requestFocus();
                }
            });
            this.passwortFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BenutzerDatenDialog.this.loginButton.requestFocus();
                    BenutzerDatenDialog.this.loginButton.doClick();
                }
            });
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (!BenutzerDatenDialog.this.busy) {
                        BenutzerDatenDialog.this.success = false;
                        BenutzerDatenDialog.this.close();
                    }
                }
            });
            this.loginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BenutzerDatenDialog.this.loginButton.setEnabled(false);
                    BenutzerDatenDialog.this.benutzerFeld.setEnabled(false);
                    BenutzerDatenDialog.this.passwortFeld.setEnabled(false);
                    BenutzerDatenDialog.this.busy = true;
                    BenutzerDatenDialog.this.user = BenutzerDatenDialog.this.benutzerFeld.getText();
                    BenutzerDatenDialog.this.pw = new String(BenutzerDatenDialog.this.passwortFeld.getPassword());
                    SwingWorkerVariant worker = new SwingWorkerVariant(BenutzerDatenDialog.this.benutzerFeld){
                        boolean tmp;
                        {
                            this.tmp = false;
                        }

                        @Override
                        protected void doNonUILogic() throws RuntimeException {
                            try {
                                this.tmp = HibernateSessionFactory.checkCredentials(BenutzerDatenDialog.this.user, BenutzerDatenDialog.this.pw);
                            }
                            catch (HibernateException e) {
                                this.fatalError = true;
                            }
                        }

                        @Override
                        protected void doUIUpdateLogic() throws RuntimeException {
                            if (this.tmp) {
                                BenutzerDatenDialog.this.success = true;
                                HauptFrame.this.settings.setSetting("auik.prefs.lastuser", BenutzerDatenDialog.this.user, true);
                                BenutzerDatenDialog.this.close();
                            } else {
                                JOptionPane.showMessageDialog(BenutzerDatenDialog.this, "Der eingegebene Benutzername oder das Passwort war falsch (oder es ist aus anderen\nGr\u00fcnden keine Verbindung mit der Datenbank m\u00f6glich), bitte versuchen Sie es erneut!", "Fehler", 0);
                                BenutzerDatenDialog.this.benutzerFeld.setEnabled(true);
                                BenutzerDatenDialog.this.passwortFeld.setEnabled(true);
                                BenutzerDatenDialog.this.loginButton.setEnabled(true);
                                BenutzerDatenDialog.this.busy = false;
                                BenutzerDatenDialog.this.passwortFeld.setText("");
                                BenutzerDatenDialog.this.benutzerFeld.setSelectionStart(0);
                                BenutzerDatenDialog.this.benutzerFeld.setSelectionEnd(BenutzerDatenDialog.this.benutzerFeld.getText().length());
                            }
                        }
                    };
                    worker.start();
                }
            });
            FormLayout layout = new FormLayout("right:pref, 4dlu, pref:grow, 4dlu, pref", "pref:grow, 3dlu, pref, 3dlu, pref, 5dlu:grow");
            layout.setRowGroups((int[][])new int[][]{{3, 5}});
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.textLabel, cc.xyw(1, 1, 5));
            builder.addLabel("Benutzer:", cc.xy(1, 3));
            builder.add((Component)this.benutzerFeld, cc.xy(3, 3));
            builder.addLabel("Passwort:", cc.xy(1, 5));
            builder.add((Component)this.passwortFeld, cc.xy(3, 5));
            builder.add((Component)this.loginButton, cc.xy(5, 5));
            this.setContentPane(builder.getPanel());
            this.pack();
        }

        public void close() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.escListener);
            this.dispose();
        }

        public boolean loginSuccessful() {
            super.setVisible(true);
            return this.success;
        }
    }
}

