/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.Modul;
import de.bielefeld.umweltamt.aui.ModulManager;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.MD5Password;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class AbstractModul
implements Modul {
    private String id;
    protected JPanel panel = null;
    protected Icon icon = null;
    protected HauptFrame frame;
    protected ModulManager manager;
    protected boolean shown = false;

    @Override
    public void setFrame(HauptFrame f) {
        this.frame = f;
    }

    @Override
    public void setManager(ModulManager m) {
        this.manager = m;
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(null);
    }

    protected Icon getIcon(String iconPath) {
        return this.getIcon(32, iconPath);
    }

    protected Icon getIcon(int size, String iconPath) {
        if (this.icon == null) {
            this.icon = AuikUtils.getIcon(size, iconPath, this.getName());
        }
        return this.icon;
    }

    @Override
    public String getIdentifier() {
        if (this.id == null) {
            this.id = MD5Password.getEncodedPassword(this.getName() + this.getCategory() + System.currentTimeMillis());
            AUIKataster.debugOutput("ID von " + this.getName() + ": '" + this.id + "'", "AbstractModul.getIdentifier()");
        }
        return this.id;
    }

    @Override
    public void show() {
        AUIKataster.debugOutput("shown", this.getIdentifier());
        this.shown = true;
    }

    @Override
    public void hide() {
        AUIKataster.debugOutput("hidden", this.getIdentifier());
        this.shown = false;
    }

    @Override
    public final boolean isShown() {
        return this.shown;
    }
}

