/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.holders.SynchronizedIntHolder;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class BasicResourcePool
implements ResourcePool {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$resourcepool$BasicResourcePool == null ? (class$com$mchange$v2$resourcepool$BasicResourcePool = BasicResourcePool.class$("com.mchange.v2.resourcepool.BasicResourcePool")) : class$com$mchange$v2$resourcepool$BasicResourcePool);
    static final int CULL_FREQUENCY_DIVISOR = 8;
    static final int MAX_CULL_FREQUENCY = 900000;
    ResourcePool.Manager mgr;
    BasicResourcePoolFactory factory;
    AsynchronousRunner taskRunner;
    RunnableQueue asyncEventQueue;
    Timer cullAndIdleRefurbishTimer;
    TimerTask cullTask;
    TimerTask idleRefurbishTask;
    HashSet acquireWaiters = new HashSet();
    HashSet otherWaiters = new HashSet();
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    Set idleCheckResources = new HashSet();
    ResourcePoolEventSupport rpes = new ResourcePoolEventSupport(this);
    boolean force_kill_acquires = false;
    boolean broken = false;
    Object exampleResource;
    int start;
    int min;
    int max;
    int inc;
    int num_acq_attempts;
    int acq_attempt_delay;
    long check_idle_resources_delay;
    long max_resource_age;
    boolean age_is_absolute;
    boolean break_on_acquisition_failure;
    SynchronizedIntHolder pendingAcquiresCounter = new SynchronizedIntHolder();
    static /* synthetic */ Class class$com$mchange$v2$resourcepool$BasicResourcePool;

    public BasicResourcePool(ResourcePool.Manager mgr, int start, int min, int max, int inc, int num_acq_attempts, int acq_attempt_delay, long check_idle_resources_delay, long max_resource_age, boolean age_is_absolute, boolean break_on_acquisition_failure, AsynchronousRunner taskRunner, RunnableQueue asyncEventQueue, Timer cullAndIdleRefurbishTimer, BasicResourcePoolFactory factory) throws ResourcePoolException {
        try {
            this.mgr = mgr;
            this.start = start;
            this.min = min;
            this.max = max;
            this.inc = inc;
            this.num_acq_attempts = num_acq_attempts;
            this.acq_attempt_delay = acq_attempt_delay;
            this.check_idle_resources_delay = check_idle_resources_delay;
            this.max_resource_age = max_resource_age;
            this.age_is_absolute = age_is_absolute;
            this.factory = factory;
            this.taskRunner = taskRunner;
            this.asyncEventQueue = asyncEventQueue;
            this.cullAndIdleRefurbishTimer = cullAndIdleRefurbishTimer;
            this.pendingAcquiresCounter.setValue(0);
            this.ensureStartResources();
            if (max_resource_age > 0L) {
                long cull_frequency = Math.min(max_resource_age / 8L, 900000L);
                this.cullTask = new CullTask();
                cullAndIdleRefurbishTimer.schedule(this.cullTask, max_resource_age, cull_frequency);
            } else {
                age_is_absolute = false;
            }
            if (check_idle_resources_delay > 0L) {
                this.idleRefurbishTask = new CheckIdleResourcesTask();
                cullAndIdleRefurbishTimer.schedule(this.idleRefurbishTask, check_idle_resources_delay, check_idle_resources_delay);
            }
        }
        catch (Exception e) {
            throw ResourcePoolUtils.convertThrowable(e);
        }
    }

    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh??? TimeoutException with no timeout set!!!", e);
            }
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object checkoutResource(long timeout) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            this.ensureNotBroken();
            int available = this.unused.size();
            if (available == 0) {
                int msz = this.managed.size();
                if (msz < this.max) {
                    this.postAcquireMore();
                }
                this.awaitAcquire(timeout);
            }
            Object resc = this.unused.get(0);
            this.unused.remove(0);
            if (this.idleCheckResources.contains(resc)) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out is in idleCheck! (waiting until idle-check completes.) [" + this + "]");
                }
                this.unused.add(resc);
                Thread t = Thread.currentThread();
                try {
                    this.otherWaiters.add(t);
                    this.wait(timeout);
                    this.ensureNotBroken();
                }
                finally {
                    this.otherWaiters.remove(t);
                }
                return this.checkoutResource(timeout);
            }
            if (this.isExpired(resc) || !this.attemptRefurbishResourceOnCheckout(resc)) {
                this.removeResource(resc);
                this.ensureMinResources();
                return this.checkoutResource(timeout);
            }
            this.asyncFireResourceCheckedOut(resc, this.managed.size(), this.unused.size(), this.excluded.size());
            this.trace();
            return resc;
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " -- the pool was found to be closed or broken during an attempt to check out a resource.", e);
            }
            this.unexpectedBreak();
            throw e;
        }
        catch (InterruptedException e) {
            if (this.broken) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. " + "[Thread: " + Thread.currentThread().getName() + ']', e);
                } else if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. " + "[Thread: " + Thread.currentThread().getName() + ']');
                }
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, this + " -- an attempt to checkout a resource was interrupted, and the pool is still live: some other thread " + "must have either interrupted the Thread attempting checkout!", e);
            }
            throw e;
        }
    }

    public synchronized void checkinResource(Object resc) throws ResourcePoolException {
        try {
            if (this.managed.keySet().contains(resc)) {
                this.doCheckinManaged(resc);
            } else if (this.excluded.contains(resc)) {
                this.doCheckinExcluded(resc);
            } else {
                throw new ResourcePoolException("ResourcePool" + (this.broken ? " [BROKEN!]" : "") + ": Tried to check-in a foreign resource!");
            }
            this.trace();
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinResource( ... ) -- even broken pools should allow checkins without exception. probable resource pool bug.", e);
            }
            this.unexpectedBreak();
            throw e;
        }
    }

    public synchronized void checkinAll() throws ResourcePoolException {
        try {
            HashSet checkedOutNotExcluded = new HashSet(this.managed.keySet());
            checkedOutNotExcluded.removeAll(this.unused);
            Iterator ii = checkedOutNotExcluded.iterator();
            while (ii.hasNext()) {
                this.doCheckinManaged(ii.next());
            }
            ii = this.excluded.iterator();
            while (ii.hasNext()) {
                this.doCheckinExcluded(ii.next());
            }
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinAll() -- even broken pools should allow checkins without exception. probable resource pool bug.", e);
            }
            this.unexpectedBreak();
            throw e;
        }
    }

    public synchronized int statusInPool(Object resc) throws ResourcePoolException {
        try {
            if (this.unused.contains(resc)) {
                return 0;
            }
            if (this.managed.keySet().contains(resc) || this.excluded.contains(resc)) {
                return 1;
            }
            return -1;
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", e);
            }
            this.unexpectedBreak();
            throw e;
        }
    }

    public synchronized void markBroken(Object resc) {
        try {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Resource " + resc + " marked broken by pool (" + this + ").");
            }
            this._markBroken(resc);
            this.ensureMinResources();
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", e);
            }
            this.unexpectedBreak();
        }
    }

    public int getMinPoolSize() {
        return this.min;
    }

    public int getMaxPoolSize() {
        return this.max;
    }

    public synchronized int getPoolSize() throws ResourcePoolException {
        return this.managed.size();
    }

    public void setPoolSize(int sz) throws ResourcePoolException {
        try {
            Exception exc = this.doSetPoolSize(sz);
            if (exc != null) {
                if (exc instanceof RuntimeException) {
                    throw (RuntimeException)exc;
                }
                throw ResourcePoolUtils.convertThrowable(exc);
            }
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", e);
            }
            this.unexpectedBreak();
        }
    }

    public synchronized int getAvailableCount() {
        return this.unused.size();
    }

    public synchronized int getExcludedCount() {
        return this.excluded.size();
    }

    public synchronized int getAwaitingCheckinCount() {
        return this.managed.size() - this.unused.size() + this.excluded.size();
    }

    public synchronized void resetPool() {
        try {
            Iterator ii = this.cloneOfManaged().keySet().iterator();
            while (ii.hasNext()) {
                this.markBrokenNoEnsureMinResources(ii.next());
            }
            this.ensureMinResources();
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", e);
            }
            this.unexpectedBreak();
        }
    }

    public synchronized void close() throws ResourcePoolException {
        this.close(true);
    }

    public void finalize() throws Throwable {
        if (!this.broken) {
            this.close();
        }
    }

    public void addResourcePoolListener(ResourcePoolListener rpl) {
        if (this.asyncEventQueue == null) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. " + "Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.addResourcePoolListener(rpl);
    }

    public void removeResourcePoolListener(ResourcePoolListener rpl) {
        if (this.asyncEventQueue == null) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. " + "Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.removeResourcePoolListener(rpl);
    }

    private synchronized boolean isForceKillAcquiresPending() {
        return this.force_kill_acquires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void forceKillAcquires() throws InterruptedException {
        Thread t = Thread.currentThread();
        try {
            this.force_kill_acquires = true;
            this.notifyAll();
            while (this.acquireWaiters.size() > 0) {
                this.otherWaiters.add(t);
                this.wait();
            }
            this.force_kill_acquires = false;
        }
        finally {
            this.otherWaiters.remove(t);
        }
    }

    private synchronized void unexpectedBreak() {
        if (logger.isLoggable(MLevel.SEVERE)) {
            logger.log(MLevel.SEVERE, this + " -- Unexpectedly broken!!!", new ResourcePoolException("Unexpected Break Stack Trace!"));
        }
        this.close(false);
    }

    private void postAcquireUntil(int num) {
        this.taskRunner.postRunnable(new AcquireTask(num));
    }

    private void postRemoveTowards(int num) {
        this.taskRunner.postRunnable(new RemoveTask(num));
    }

    private boolean canFireEvents() {
        return !this.broken && this.asyncEventQueue != null;
    }

    private void asyncFireResourceAcquired(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        if (this.canFireEvents()) {
            Runnable r = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceAcquired(resc, pool_size, available_size, removed_but_unreturned_size);
                }
            };
            this.asyncEventQueue.postRunnable(r);
        }
    }

    private void asyncFireResourceCheckedIn(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        if (this.canFireEvents()) {
            Runnable r = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedIn(resc, pool_size, available_size, removed_but_unreturned_size);
                }
            };
            this.asyncEventQueue.postRunnable(r);
        }
    }

    private void asyncFireResourceCheckedOut(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        if (this.canFireEvents()) {
            Runnable r = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedOut(resc, pool_size, available_size, removed_but_unreturned_size);
                }
            };
            this.asyncEventQueue.postRunnable(r);
        }
    }

    private void asyncFireResourceRemoved(final Object resc, final boolean checked_out_resource, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        if (this.canFireEvents()) {
            Runnable r = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceRemoved(resc, checked_out_resource, pool_size, available_size, removed_but_unreturned_size);
                }
            };
            this.asyncEventQueue.postRunnable(r);
        }
    }

    private void destroyResource(Object resc) {
        this.destroyResource(resc, false);
    }

    private void destroyResource(final Object resc, boolean synchronous) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    try {
                        BasicResourcePool.this.mgr.destroyResource(resc);
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block2;
                        logger.log(MLevel.WARNING, "Failed to destroy resource: " + resc, e);
                    }
                }
            }
        };
        if (synchronous) {
            r.run();
        } else {
            this.taskRunner.postRunnable(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireUntil(int num) throws Exception {
        int msz;
        do {
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                msz = this.managed.size();
            }
            if (msz < num) {
                Object resc = this.mgr.acquireResource();
                boolean destroy = false;
                BasicResourcePool basicResourcePool2 = this;
                synchronized (basicResourcePool2) {
                    msz = this.managed.size();
                    if (msz < num) {
                        this.assimilateResource(resc);
                        ++msz;
                    } else {
                        destroy = true;
                    }
                }
                if (destroy) {
                    this.mgr.destroyResource(resc);
                }
            }
            Thread.currentThread();
            Thread.yield();
        } while (msz < num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception doSetPoolSize(int sz) {
        try {
            int msz;
            if (sz > this.max) {
                throw new IllegalArgumentException("Requested size [" + sz + "] is greater than max [" + this.max + "].");
            }
            if (sz < this.min) {
                throw new IllegalArgumentException("Requested size [" + sz + "] is less than min [" + this.min + "].");
            }
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                msz = this.managed.size();
            }
            if (sz > msz) {
                this.acquireUntil(sz);
            } else if (sz < msz) {
                basicResourcePool = this;
                synchronized (basicResourcePool) {
                    int num_to_cull = msz - sz;
                    int usz = this.unused.size();
                    int num_from_unused = Math.min(num_to_cull, usz);
                    for (int i = 0; i < num_from_unused; ++i) {
                        this.removeResource(this.unused.get(0));
                    }
                    int num_outstanding_to_cull = num_to_cull - num_from_unused;
                    Iterator ii = this.cloneOfManaged().keySet().iterator();
                    for (int i = 0; i < num_outstanding_to_cull; ++i) {
                        this.excludeResource(ii.next());
                    }
                    this.notifyAll();
                }
            }
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private void markBrokenNoEnsureMinResources(Object resc) {
        try {
            this._markBroken(resc);
        }
        catch (ResourceClosedException e) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", e);
            }
            this.unexpectedBreak();
        }
    }

    private void _markBroken(Object resc) {
        if (this.unused.contains(resc)) {
            this.removeResource(resc);
        } else {
            this.excludeResource(resc);
        }
    }

    private void close(boolean close_checked_out_resources) {
        if (!this.broken) {
            Collection<Object> cleanupResources;
            this.broken = true;
            Collection<Object> collection = cleanupResources = close_checked_out_resources ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
            if (this.cullTask != null) {
                this.cullTask.cancel();
            }
            if (this.idleRefurbishTask != null) {
                this.idleRefurbishTask.cancel();
            }
            Iterator<Object> ii = cleanupResources.iterator();
            while (ii.hasNext()) {
                try {
                    Object resc = ii.next();
                    if (this.unused.contains(resc)) {
                        this.removeResource(resc, true);
                        continue;
                    }
                    this.excludeResource(resc);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(MLevel.FINE)) continue;
                    logger.log(MLevel.FINE, "BasicResourcePool -- A resource couldn't be cleaned up on close()", e);
                }
            }
            ii = this.acquireWaiters.iterator();
            while (ii.hasNext()) {
                ((Thread)ii.next()).interrupt();
            }
            ii = this.otherWaiters.iterator();
            while (ii.hasNext()) {
                ((Thread)ii.next()).interrupt();
            }
            if (this.factory != null) {
                this.factory.markBroken(this);
            }
        } else if (logger.isLoggable(MLevel.WARNING)) {
            logger.warning(this + " -- close() called multiple times.");
        }
    }

    private void doCheckinManaged(final Object resc) throws ResourcePoolException {
        if (this.unused.contains(resc)) {
            throw new ResourcePoolException("Tried to check-in an already checked-in resource: " + resc);
        }
        Runnable doMe = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    boolean resc_okay = BasicResourcePool.this.attemptRefurbishResourceOnCheckin(resc);
                    if (resc_okay) {
                        BasicResourcePool.this.unused.add(resc);
                        if (!BasicResourcePool.this.age_is_absolute) {
                            BasicResourcePool.this.managed.put(resc, new Date());
                        }
                    } else {
                        BasicResourcePool.this.removeResource(resc);
                        BasicResourcePool.this.ensureMinResources();
                    }
                    BasicResourcePool.this.asyncFireResourceCheckedIn(resc, BasicResourcePool.this.managed.size(), BasicResourcePool.this.unused.size(), BasicResourcePool.this.excluded.size());
                    BasicResourcePool.this.notifyAll();
                }
            }
        };
        this.taskRunner.postRunnable(doMe);
    }

    private void doCheckinExcluded(Object resc) {
        this.excluded.remove(resc);
        this.destroyResource(resc);
    }

    private void postAcquireMore() {
        int msz = this.managed.size();
        int pending_acquires = this.pendingAcquiresCounter.getValue();
        int num_desired = msz + Math.max(this.inc, pending_acquires + 1);
        this.postAcquireUntil(Math.min(num_desired, this.max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAcquire(long timeout) throws InterruptedException, TimeoutException, ResourcePoolException {
        if (this.force_kill_acquires) {
            throw new ResourcePoolException("A ResourcePool cannot acquire a new resource -- the factory or source appears to be down.");
        }
        Thread t = Thread.currentThread();
        try {
            int avail;
            long start;
            this.acquireWaiters.add(t);
            long l = start = timeout > 0L ? System.currentTimeMillis() : -1L;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("awaitAvailable(): " + (this.exampleResource != null ? this.exampleResource : "[unknown]"));
            }
            this.trace();
            while ((avail = this.unused.size()) == 0) {
                if (this.pendingAcquiresCounter.getValue() == 0) {
                    this.postAcquireMore();
                }
                this.wait(timeout);
                if (timeout > 0L && System.currentTimeMillis() - start > timeout) {
                    throw new TimeoutException("internal -- timeout at awaitAcquire()");
                }
                if (this.force_kill_acquires) {
                    throw new CannotAcquireResourceException("A ResourcePool could not acquire a resource from its primary factory or source.");
                }
                this.ensureNotBroken();
            }
            Object var8_5 = null;
            this.acquireWaiters.remove(t);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.acquireWaiters.remove(t);
            if (this.acquireWaiters.size() == 0) {
                this.notifyAll();
            }
            throw throwable;
        }
        if (this.acquireWaiters.size() == 0) {
            this.notifyAll();
        }
    }

    private void assimilateResource(Object resc) throws Exception {
        this.managed.put(resc, new Date());
        this.unused.add(resc);
        this.asyncFireResourceAcquired(resc, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
        this.trace();
        if (this.exampleResource == null) {
            this.exampleResource = resc;
        }
    }

    private void removeResource(Object resc) {
        this.removeResource(resc, false);
    }

    private void removeResource(Object resc, boolean synchronous) {
        this.managed.remove(resc);
        this.unused.remove(resc);
        this.destroyResource(resc, synchronous);
        this.asyncFireResourceRemoved(resc, false, this.managed.size(), this.unused.size(), this.excluded.size());
        this.trace();
    }

    private void excludeResource(Object resc) {
        this.managed.remove(resc);
        this.excluded.add(resc);
        if (this.unused.contains(resc)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        this.asyncFireResourceRemoved(resc, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int new_sz) {
        int num_to_remove = this.managed.size() - new_sz;
        Iterator ii = this.cloneOfUnused().iterator();
        for (int count = 0; ii.hasNext() && count < num_to_remove; ++count) {
            Object resc = ii.next();
            this.removeResource(resc);
        }
    }

    private void cullExpiredAndUnused() {
        Iterator ii = this.cloneOfUnused().iterator();
        while (ii.hasNext()) {
            Object resc = ii.next();
            if (!this.isExpired(resc)) continue;
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Removing expired resource: " + resc + " [" + this + "]");
            }
            this.removeResource(resc);
        }
        this.ensureMinResources();
    }

    private void checkIdleResources() {
        LinkedList u = this.cloneOfUnused();
        Iterator ii = u.iterator();
        while (ii.hasNext()) {
            Object resc = ii.next();
            if (!this.idleCheckResources.add(resc)) continue;
            this.taskRunner.postRunnable(new AsyncTestIdleResourceTask(resc));
        }
        this.trace();
    }

    private boolean isExpired(Object resc) {
        if (this.max_resource_age > 0L) {
            boolean expired;
            Date d = (Date)this.managed.get(resc);
            long now = System.currentTimeMillis();
            long age = now - d.getTime();
            boolean bl = expired = age > this.max_resource_age;
            if (logger.isLoggable(MLevel.FINEST)) {
                if (expired) {
                    logger.log(MLevel.FINEST, "EXPIRED resource: " + resc + " ---> age: " + age + "   max: " + this.max_resource_age + " [" + this + "]");
                } else {
                    logger.log(MLevel.FINEST, "resource age is okay: " + resc + " ---> age: " + age + "   max: " + this.max_resource_age + " [" + this + "]");
                }
            }
            return expired;
        }
        return false;
    }

    private void ensureStartResources() {
        this.postAcquireUntil(Math.max(this.start, this.min));
    }

    private void ensureMinResources() {
        if (this.managed.size() < this.min) {
            this.postAcquireUntil(this.min);
        }
    }

    private boolean attemptRefurbishResourceOnCheckout(Object resc) {
        try {
            this.mgr.refurbishResourceOnCheckout(resc);
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkout.", e);
            }
            return false;
        }
    }

    private boolean attemptRefurbishResourceOnCheckin(Object resc) {
        try {
            this.mgr.refurbishResourceOnCheckin(resc);
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkin.", e);
            }
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private void trace() {
        if (logger.isLoggable(MLevel.FINEST)) {
            String exampleResStr = this.exampleResource == null ? "" : " (e.g. " + this.exampleResource + ")";
            logger.finest("trace " + this + " [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + exampleResStr);
        }
    }

    private final HashMap cloneOfManaged() {
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        return (HashSet)this.excluded.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AsyncTestIdleResourceTask
    implements Runnable {
        Object resc;
        boolean pending = true;
        boolean failed;

        AsyncTestIdleResourceTask(Object resc) {
            this.resc = resc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicResourcePool basicResourcePool;
            try {
                boolean failed;
                try {
                    BasicResourcePool.this.mgr.refurbishIdleResource(this.resc);
                    failed = false;
                }
                catch (Exception e) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "BasicResourcePool: An idle resource is broken and will be purged.", e);
                    }
                    failed = true;
                }
                BasicResourcePool basicResourcePool2 = BasicResourcePool.this;
                synchronized (basicResourcePool2) {
                    if (failed && BasicResourcePool.this.managed.keySet().contains(this.resc)) {
                        BasicResourcePool.this.removeResource(this.resc);
                        BasicResourcePool.this.ensureMinResources();
                    }
                }
                Object var5_5 = null;
                basicResourcePool = BasicResourcePool.this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                BasicResourcePool basicResourcePool3 = BasicResourcePool.this;
                synchronized (basicResourcePool3) {
                    BasicResourcePool.this.idleCheckResources.remove(this.resc);
                    BasicResourcePool.this.notifyAll();
                }
                throw throwable;
            }
            synchronized (basicResourcePool) {
                BasicResourcePool.this.idleCheckResources.remove(this.resc);
                BasicResourcePool.this.notifyAll();
            }
        }
    }

    class CheckIdleResourcesTask
    extends TimerTask {
        CheckIdleResourcesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Refurbishing idle resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.checkIdleResources();
                }
            }
            catch (ResourceClosedException e) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", e);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class RemoveTask
    implements Runnable {
        int num;

        public RemoveTask(int num) {
            this.num = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.removeTowards(this.num);
                }
            }
            catch (ResourceClosedException e) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", e);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Checking for expired resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.cullExpiredAndUnused();
                }
            }
            catch (ResourceClosedException e) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", e);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;
        int num;

        public AcquireTask(int num) {
            this.num = num;
            BasicResourcePool.this.pendingAcquiresCounter.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int i = 0;
                while (this.shouldTry(i)) {
                    block18: {
                        try {
                            if (i > 0) {
                                Thread.sleep(BasicResourcePool.this.acq_attempt_delay);
                            }
                            BasicResourcePool.this.acquireUntil(this.num);
                            this.success = true;
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(MLevel.FINE)) break block18;
                            logger.log(MLevel.FINE, "An exception occurred while acquiring a resource.", e);
                        }
                    }
                    ++i;
                }
                if (!this.success) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, this + " -- Acquisition Attempt Failed!!! Clearing pending acquires. " + "While trying to acquire a needed new resource, we failed " + "to succeed more than the maximum number of allowed " + "acquisition attempts (" + BasicResourcePool.this.num_acq_attempts + ").");
                    }
                    if (BasicResourcePool.this.break_on_acquisition_failure) {
                        if (logger.isLoggable(MLevel.SEVERE)) {
                            logger.severe("THE RESOURCE POOL IS PERMANENTLY BROKEN! [" + this + "]");
                        }
                        BasicResourcePool.this.unexpectedBreak();
                    } else {
                        BasicResourcePool.this.forceKillAcquires();
                    }
                }
            }
            catch (ResourceClosedException e) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", e);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
            catch (InterruptedException e) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, BasicResourcePool.this + " -- Thread unexpectedly interrupted while waiting for stale acquisition attempts to die.", e);
                }
            }
            finally {
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
            }
        }

        private boolean shouldTry(int attempt_num) {
            return !this.success && !BasicResourcePool.this.isForceKillAcquiresPending() && (BasicResourcePool.this.num_acq_attempts <= 0 || attempt_num < BasicResourcePool.this.num_acq_attempts);
        }
    }
}

