/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    String[] rps;
    Map propsByResourcePaths = new HashMap();
    Map propsByPrefixes;
    Properties propsByKey;
    static /* synthetic */ Class class$com$mchange$v2$cfg$MultiPropertiesConfig;
    static /* synthetic */ Class class$com$mchange$v2$cfg$BasicMultiPropertiesConfig;

    public BasicMultiPropertiesConfig(String[] resourcePaths) {
        this(resourcePaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BasicMultiPropertiesConfig(String[] resourcePaths, MLogger logger) {
        ArrayList<String> goodPaths = new ArrayList<String>();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            Properties p = new Properties();
            InputStream pis = (class$com$mchange$v2$cfg$MultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.MultiPropertiesConfig") : class$com$mchange$v2$cfg$MultiPropertiesConfig).getResourceAsStream(rp);
            if (pis != null) {
                p.load(pis);
                this.propsByResourcePaths.put(rp, p);
                goodPaths.add(rp);
                Object var11_10 = null;
                try {
                    if (pis == null) continue;
                    pis.close();
                }
                catch (IOException e2) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                        continue;
                    }
                    e2.printStackTrace();
                }
                continue;
                {
                    catch (IOException e) {
                        if (logger != null) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "An IOException occurred while loading configuration properties from resource path '" + rp + "'.", e);
                            }
                        } else {
                            e.printStackTrace();
                        }
                        var11_10 = null;
                        try {
                            if (pis == null) continue;
                            pis.close();
                        }
                        catch (IOException e2) {
                            if (logger != null) {
                                if (!logger.isLoggable(MLevel.WARNING)) continue;
                                logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                                continue;
                            }
                            e2.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    block18: {
                        var11_10 = null;
                        try {
                            if (pis != null) {
                                pis.close();
                            }
                        }
                        catch (IOException e2) {
                            if (logger != null) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                                }
                                break block18;
                            }
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            if (logger == null || !logger.isLoggable(MLevel.FINE)) continue;
            logger.fine("Configuration properties not found at ResourcePath '" + rp + "'. [logger name: " + logger.getName() + ']');
        }
        this.rps = goodPaths.toArray(new String[goodPaths.size()]);
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths));
        this.propsByResourcePaths = Collections.unmodifiableMap(this.propsByResourcePaths);
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths);
    }

    private static String extractPrefix(String s) {
        int lastdot = s.lastIndexOf(46);
        if (lastdot < 0) {
            return null;
        }
        return s.substring(0, lastdot);
    }

    private static Properties findProps(String rp, Map pbrp) {
        Properties p;
        if ("/".equals(rp)) {
            try {
                p = System.getProperties();
            }
            catch (SecurityException e) {
                System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? (class$com$mchange$v2$cfg$BasicMultiPropertiesConfig = BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig")) : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + " Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! " + "(But any configuration via a resource properties files is still okay!)");
                p = new Properties();
            }
        } else {
            p = (Properties)pbrp.get(rp);
        }
        return p;
    }

    private static Properties extractPropsByKey(String[] resourcePaths, Map pbrp) {
        Properties out = new Properties();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println("Could not find loaded properties for resource path: " + rp);
                continue;
            }
            Iterator<Object> ii = p.keySet().iterator();
            while (ii.hasNext()) {
                String key = (String)ii.next();
                String val = (String)p.get(key);
                out.put(key, val);
            }
        }
        return out;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] resourcePaths, Map pbrp) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + " -- Could not find loaded properties for resource path: " + rp);
                continue;
            }
            Iterator<Object> jj = p.keySet().iterator();
            while (jj.hasNext()) {
                String key = (String)jj.next();
                String prefix = BasicMultiPropertiesConfig.extractPrefix(key);
                while (prefix != null) {
                    Properties byPfx = (Properties)out.get(prefix);
                    if (byPfx == null) {
                        byPfx = new Properties();
                        out.put(prefix, byPfx);
                    }
                    byPfx.put(key, p.get(key));
                    prefix = BasicMultiPropertiesConfig.extractPrefix(prefix);
                }
            }
        }
        return out;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        return (Properties)this.propsByResourcePaths.get(path);
    }

    public Properties getPropertiesByPrefix(String pfx) {
        return (Properties)this.propsByPrefixes.get(pfx);
    }

    public String getProperty(String key) {
        return this.propsByKey.getProperty(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

