/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumberFormatter {
    protected static Logger logger = Logger.getLogger(NumberFormatter.class.getName());
    protected String formatPattern;
    protected boolean parseBigDecimal;
    protected ULocale locale = ULocale.getDefault();
    protected NumberFormat numberFormat;
    protected NumberFormat decimalFormat;
    protected char decimalSeparator;
    private boolean hexFlag;

    public NumberFormatter() {
        this.applyPattern(null);
    }

    public NumberFormatter(String format) {
        this.applyPattern(format);
    }

    public NumberFormatter(ULocale locale) {
        this.locale = locale;
        this.applyPattern(null);
    }

    public NumberFormatter(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public NumberFormatter(String pattern, ULocale locale) {
        this.locale = locale;
        this.parseBigDecimal = false;
        this.applyPattern(pattern);
    }

    public NumberFormatter(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale((Locale)locale));
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String patternStr) {
        try {
            this.formatPattern = patternStr;
            this.hexFlag = false;
            if (this.formatPattern == null) {
                this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
                this.numberFormat.setGroupingUsed(false);
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale.toLocale());
                this.decimalSeparator = symbols.getDecimalSeparator();
                this.decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(this.locale.toLocale()));
                this.decimalFormat.setMinimumIntegerDigits(1);
                this.decimalFormat.setGroupingUsed(false);
                return;
            }
            if (patternStr.length() == 1) {
                this.handleSingleCharFormatString(patternStr.charAt(0));
                return;
            }
            this.handleNamedFormats(patternStr);
        }
        catch (Exception illeagueE) {
            logger.log(Level.WARNING, illeagueE.getMessage(), illeagueE);
        }
    }

    public String format(double num) {
        block7: {
            try {
                if (!Double.isNaN(num)) break block7;
                return "NaN";
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        if (this.hexFlag) {
            return Long.toHexString(new Double(num).longValue());
        }
        if (num == 0.0) {
            num = 0.0;
        }
        if (this.formatPattern == null) {
            long longValue = Math.round(num);
            if ((double)longValue == num) {
                return Long.toString(longValue);
            }
            String result = Double.toString(num);
            return result.replace('.', this.decimalSeparator);
        }
        return this.numberFormat.format(num);
    }

    public String format(BigDecimal bigDecimal) {
        try {
            if (this.hexFlag) {
                return Long.toHexString(bigDecimal.longValue());
            }
            if (this.formatPattern == null) {
                return this.decimalFormat.format(bigDecimal);
            }
            return this.numberFormat.format(bigDecimal);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String format(Number number) {
        block6: {
            try {
                if (!Double.isNaN(number.doubleValue())) break block6;
                return "NaN";
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        if (this.hexFlag) {
            return Long.toHexString(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return this.format(number.doubleValue());
        }
        if (this.formatPattern == null && number instanceof BigDecimal) {
            return this.decimalFormat.format(number);
        }
        return this.numberFormat.format(number);
    }

    public String format(long num) {
        if (this.hexFlag) {
            return Long.toHexString(num);
        }
        return this.numberFormat.format(num);
    }

    private void handleSingleCharFormatString(char c) {
        switch (c) {
            case 'D': 
            case 'G': 
            case 'd': 
            case 'g': {
                this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
                return;
            }
            case 'C': 
            case 'c': {
                this.numberFormat = NumberFormat.getCurrencyInstance(this.locale.toLocale());
                return;
            }
            case 'F': 
            case 'f': {
                this.numberFormat = new DecimalFormat("#0.00", new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'N': 
            case 'n': {
                this.numberFormat = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'P': 
            case 'p': {
                this.numberFormat = new DecimalFormat("###,##0.00 %", new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'E': 
            case 'e': {
                this.numberFormat = new DecimalFormat("0.000000E00", new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'X': 
            case 'x': {
                this.hexFlag = true;
                return;
            }
        }
        char[] data = new char[]{c};
        String str = new String(data);
        this.numberFormat = new DecimalFormat(str, new DecimalFormatSymbols(this.locale.toLocale()));
    }

    private void handleNamedFormats(String patternStr) {
        if (patternStr.equals("General Number") || patternStr.equals("Unformatted")) {
            this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
            this.numberFormat.setGroupingUsed(false);
            return;
        }
        if (patternStr.equals("Fixed")) {
            this.numberFormat = new DecimalFormat("#0.00", new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        if (patternStr.equals("Percent")) {
            this.numberFormat = new DecimalFormat("0.00%", new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        if (patternStr.equals("Scientific")) {
            this.numberFormat = new DecimalFormat("0.00E00", new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        if (patternStr.equals("Standard")) {
            this.numberFormat = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        this.numberFormat = new DecimalFormat(patternStr, new DecimalFormatSymbols(this.locale.toLocale()));
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean parseBigDecimal) {
        this.parseBigDecimal = parseBigDecimal;
    }

    public Number parse(String number) throws ParseException {
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setParseBigDecimal(this.parseBigDecimal);
        }
        return this.numberFormat.parse(number);
    }
}

