	TTL	exec-sa11x0.s

	SUBT cyace

;/***************************************************************************
;/*	Copyright 2000 Compaq Computer Corporation.                             */
;/*                                                                         */
;/*	Copying or modifying this code for any purpose is permitted,            */
;/*	provided that this copyright notice is preserved in its entirety        */
;/*	in all copies or modifications.                                         */
;/*                                                                         */
;/*	COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR           */
;/*	IMPLIED, AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR            */
;/*	ITS FITNESS FOR ANY PARTICULAR PURPOSE.                                 */
;/***************************************************************************/
;
;/*+*************************************************************************
;  FACILITY:	 CyaCE (originally written for welly and adapted for CyaCE)
;
;  MODULE NAME:	 runprog-sa11x0.s
;  ABSTRACT:     Allows us to jump to a given physical address on a device
;				 running a SA-11x0.
;				 Also implements the StrongARM assembly code to copy the
;                pages to the correct place.
;
;  AUTHORS:		 Dirk van Hennekeler,   Compaq Computer Corporation.
;				 <dirk.vanhennekeler@compaq.com>
;  CREATED:		 15 November 2000
;**************************************************************************-*/

; Definitions
SA1100_UART1BASE	EQU		0x80010000
SA1100_UART3BASE	EQU		0x80050000
BITSY_EGPIO			EQU		0x49000000
SA1100_UTSR0		EQU		0x1c
SA1100_UTSR1		EQU		0x20
SA1100_UTCR0		EQU		0x00
SA1100_UTCR1		EQU		0x04
SA1100_UTCR2		EQU		0x08
SA1100_UTCR3		EQU		0x0C
SA1100_UTCR0_8BIT	EQU		(1 << 3)		; 1 for 8 bit data 
UART_BAUD_RATE		EQU		115200			; should be 57600??
SA1100_UTCR3_RXE	EQU		(1 << 0)		; receiver enable 
SA1100_UTCR3_TXE	EQU		(1 << 1)		; transmit enable 
SA1100_UTDR			EQU		0x14
EGPIO_BITSY_RS232_ON EQU     (1 << 7)		; UART3 transceiver force on.  Active high. 


; [1] 11.11.8 
SA1100_UTSR1_TBY	EQU     (1 << 0)		; transmit FIFO busy 
SA1100_UTSR1_RNE	EQU     (1 << 1)        ; receive FIFO not empty 
SA1100_UTSR1_TNF	EQU     (1 << 2)        ; transmit FIFO not full 
SA1100_UTSR1_PRE	EQU     (1 << 3)        ; parity error           
SA1100_UTSR1_FRE	EQU     (1 << 4)        ; framing error          
SA1100_UTSR1_ROR	EQU     (1 << 5)        ; receiver overrun       


CHAR_CR				EQU		13				; '\r'
CHAR_LF				EQU		10				; '\n'

CHAR_PERCENT		EQU		37				; '%'
CHAR_STAR			EQU		42				; '*'
CHAR_AT				EQU		64				; '@'
CHAR_AMPERSAND		EQU		38				; '&'
CHAR_CARROT			EQU		94				; '^'
CHAR_HASH			EQU		35				; '#'
CHAR_SPACE			EQU		32				; ' '
CHAR_PLUS			EQU		43				; '+'
CHAR_MINUS			EQU		45				; '-'
CHAR_STOP			EQU		46				; '.'
CHAR_SLASH			EQU		47				; '/'
CHAR_DOLLAR			EQU		36				; '$'

	EXPORT	|SA11xxAssemblyCodeHolder|	; void SA11xxAssemblyCodeHolder (void);


;/*+--------------------------------------------------------------------------
;  DESCRIPTION:
;
;	  void SA11xxAssemblyCodeHolder (void);
;
;     Allows caller to start executing code at a physical address that is 
;	  passed in.
;	  It turns off interrupts, then MMU and then jumps to the physical address
;	  that is given.
;
;  FORMAL PARAMETERS:
;	  None.
;
;  function value or completion codes
;	  This boot the kernel after completion and will not return.
;---------------------------------------------------------------------------*/

	AREA |.text|,CODE

|SA11xxAssemblyCodeHolder| PROC	; void SA11xxAssemblyCodeHolder (void);

	; void
	; startprog(register struct map_s *map)
	; {
	;   register unsigned char *addr;
	;   register unsigned char *p;
	;	register int i;
	;
	;   addr = map->base;
	;   i = 0;
	;   while (p = map->leaf[i / map->leafsize][i % map->leafsize]) {
	;     register unsigned char *pe = p + map->pagesize;
	;     while (p < pe) {
	;       *addr++ = *p++;
	;     }
	;     i++;
	;   }
	; }
	;
	;  register assignment:
	;    struct map_s *map		r0
	;    unsigned char *addr	r4
	;    unsigned char *p		r5
	;    unsigned char *pe		r6
	;    int i					r7
	;
	; struct map_s {
	;   caddr_t entry;	+0
	;   caddr_t base;	+4
	;   int pagesize;	+8
	;   int leafsize;	+12
	;   int nleaves;	+16
	;   caddr_t arg0;	+20
	;   caddr_t arg1;   +24
	;   caddr_t arg2;	+28
	;   caddr_t arg3;	+32
	;   caddr_t *leaf[32];	+36
	;
	b		Start
|MapAddr|				DCD		0x00000000			; map address
	IF :DEF: USE_UART1
Ser1Base				DCD		SA1100_UART1BASE
	ENDIF
Ser3Base				DCD		SA1100_UART3BASE
;SA1100_PPCR_ADDRESS	DCD		SA1100_PPCR_REG
;SA1100_ICMR_ADDRESS	DCD		SA1100_ICMR_REG
EGPIOBase				DCD		BITSY_EGPIO
HEX_TO_ASCII_TABLE		DCB		"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
						DCB		"A", "B", "C", "D", "E", "F"
STARTUP_MSG				DCB		"\r", "\n", "R", "U", "N", "P"
						DCB		"R", "O", "G", "\r", "\n", 0x00

USE_SERIAL				EQU	2

Start
    IF :DEF: USE_SERIAL
	;
	; We are assuming the clock speed is  MHz!
	;
    ; make sure TX fifo is empty by printing a character 
	mov     r0, #0
	ldr		r1, Ser3Base
    bl      PrintChar

	; Initialize the UARTs
;	bl		InitUART1
	bl		InitUART3
	
    bl      EnableUart3Transceiver

	adr		r6, STARTUP_MSG
	ldr     r1, Ser3Base
StartMsg
	ldr		r0, [r6], #1
	and		r0, r0, #0xff
	teq		r0, #0
	beq		StartMsgDone
	bl		PrintChar
	b		StartMsg
StartMsgDone
	ENDIF

	ldr		r0, |MapAddr|		;  get the map address in r0
	ldr		r4,	[r0, #4]		;  addr = map->base
	mov		r7, #0				;  i = 0

	;   while (p = map->leaf[i / map->leafsize][i % map->leafsize]) {
CopyAllPages
	ldr		r3, [r0, #12]		; r3 = map->leafsize
	mov		r1, #0				; clear quotient
	mov		r2, r7				; store i temporarily
	
	; IN: r2 = dividend, r3 = divisor => r2/r3
Div
	cmp		r2, r3				; r2 - r3
	blt		DivDone
	add		r1,	r1, #1			; r1 = r1 + 1
	sub		r2, r2, r3			; r2 = r2 - r3
	b		Div
DivDone
	; OUT: r1 = quotient, r2 = remainder

	;   while (p = map->leaf[i / map->leafsize][i % map->leafsize]) {
	add		r8, r0, #36
	ldr		r3, [r8, r1, LSL #2]

	ldr		r5, [r3, r2, LSL #2]; r5 = r3 + offset x 4
	teq		r5, #0				; null pointer
	beq		Done

	;     register unsigned char *pe = p + map->pagesize;
	ldr		r1, [r0, #8]		; r1 = pagesize
	add		r6, r5, r1			; r6 = pe
;	add		r6, r5, [r0, #8]	; same as above ??

	;     while (p < pe) {
	;       *addr++ = *p++;
	;     }


CopyPage
	ldr		r1, [r5], #4
	str		r1, [r4], #4
	teq		r5, r6
	bne		CopyPage

	;     i++;
	add		r7, r7, #1

	b		CopyAllPages
	;
Done

	; Now we setup the arguments and jump.
	; trashes all the other registers though.
	ldr		r6, |MapAddr|		;  get the map address in r6
	ldr		r0, [r6, #20]		; arg0
	ldr		r1, [r6, #24]		; arg1
	ldr		r2, [r6, #28]		; arg2
	ldr		r3, [r6, #32]		; arg3
	ldr		r5, [r6]			; entry point of code
	mov		pc, r5				; start the ball rolling


	IF :DEF: USE_SERIAL
	;      	
	; Enable Ser3 Transceiver
	;   r0: number of times to wiggle the enable bit
	;   modifies r0, r1, r2	
	;
EnableUart3Transceiver
    ldr     r1, EGPIOBase
	mov     r2, #EGPIO_BITSY_RS232_ON
    str     r2, [r1, #0]
    ldr     r2, [r1, #0]
    mov     pc, lr	

	IF :DEF: USE_UART1	
	;; ********************************************************************
	;; InitUART1 - Initialize Serial Communications
	;; ********************************************************************
	;; Following reset, the UART is disabled. So, we do the following:
InitUART1
	; Now clear all 'sticky' bits in serial I registers, cf. [1] 11.11 
    ldr		r1, Ser1Base
	mov		r2, #0xFF
	str		r2, [r1, #SA1100_UTSR0]		        ; UART1 Status Reg. 0 
	
    ; disable the UART 
	mov		r2, #0x00
	str		r2, [r1, #SA1100_UTCR3]				; UART1 Control Reg. 3

	; Set the serial port to sensible defaults: no break, no interrupts,
	; no parity, 8 databits, 1 stopbit.
	mov		r2, #SA1100_UTCR0_8BIT
	str		r2, [r1, #SA1100_UTCR0]				; UART1 Control Reg. 0        

UART_BRD EQU ((3686400 / 16 / UART_BAUD_RATE) - 1)
	mov		r2, #((UART_BRD >> 16) & 0xF)
	str		r2, [r1, #SA1100_UTCR1]
	mov		r2, #(UART_BRD & 0xFF)
	str		r2, [r1, #SA1100_UTCR2]

    ; enable the UART TX and RX
InitUart1Enable
	mov		r2, #(SA1100_UTCR3_RXE|SA1100_UTCR3_TXE)
	str		r2, [r1, #SA1100_UTCR3]

    ; transmit a character or two
	mov	r2, #CHAR_CARROT				; #'^'
	str	r2, [r1, #SA1100_UTDR]
	mov	r2, #CHAR_AMPERSAND				; #'&'
	str	r2, [r1, #SA1100_UTDR]

	mov	pc, lr		; All done, return
	ENDIF	; USE_UART1

	;; ********************************************************************
	;; InitUART3 - Initialize Serial Communications
	;; ********************************************************************
	;; Following reset, the UART is disabled. So, we do the following:
InitUART3
    ldr		r1, Ser3Base

    ; disable the UART 
	mov		r2, #0x00
	str		r2, [r1, #SA1100_UTCR3]         ; UART3 Control Reg. 3

	; Now clear all 'sticky' bits in serial I registers, cf. [1] 11.11
	mov		r2, #0xFF
	str		r2, [r1, #SA1100_UTSR0]         ; UART3 Status Reg. 0       
	
	; Set the serial port to sensible defaults: no break, no interrupts, 
	; no parity, 8 databits, 1 stopbit. 
	mov		r2, #SA1100_UTCR0_8BIT
	str		r2, [r1, #SA1100_UTCR0]			; UART3 Control Reg. 0       

	; Set BRD to 1, for a baudrate of 115K2 ([1] 11.11.4.1)
	; Set BRD to 3, for a baudrate of 57k6 ([1] 11.11.4.1) 
	; Set BRD to 5, for a baudrate of 38k4 ([1] 11.11.4.1) 
	; Set BRD to 23, for a baudrate of 9k6 ([1] 11.11.4.1) 
; UART3_BRD EQU ((3686400 / 16 / UART_BAUD_RATE) - 1)
UART3_BRD EQU 1
	mov		r2, #(UART3_BRD >> 8 & 0xf)	; 0 = top 4-bits
	str		r2, [r1, #SA1100_UTCR1]
	mov		r2, #(UART3_BRD & 0xff)		; 1 = bottom 8-bits
	str		r2, [r1, #SA1100_UTCR2]

    ; enable the UART TX and RX
InitUart3Enable
	mov		r2, #(SA1100_UTCR3_RXE|SA1100_UTCR3_TXE)
	str		r2, [r1, #SA1100_UTCR3]

    ; transmit a character or two
	mov		r2, #CHAR_SLASH				; #'/'
	str		r2, [r1, #SA1100_UTDR]
	mov		r2, #CHAR_HASH				; #'#'
	str		r2, [r1, #SA1100_UTDR]

    ; set forceon bit, which is in GPIO U5
	ldr     r3, EGPIOBase
    mov     r2, #(1 << 7)
	str		r2, [r3, #0]
	ldr		r2, [r3, #0]

	mov	pc, lr		; All done, return
	
	;; ********************************************************************
	;; PrintHexNibble -- prints the least-significant nibble in R0 as a
	;; hex digit
    ;;   r0 contains nibble to write as Hex
    ;;   r1 contains base of serial port
    ;;   writes r0 with RXSTAT, modifies r0,r2 
	;;   Falls through to PrintChar
	;; ********************************************************************
PrintHexNibble
	adr		r2, HEX_TO_ASCII_TABLE
	AND		r0, r0, #0xF
	ldr		r0, [r2,r0]		; convert to ascii 
	b       PrintChar

	;; ********************************************************************
	;; PrintChar -- prints the character in R0
    ;;   r0 contains the character
    ;;   r1 contains base of serial port
    ;;   writes r0 with UTSR1, modifies r0,r1,r2
	;;********************************************************************
PrintChar
TXBusy
	ldr     r2,[r1,#SA1100_UTSR1]	; check status
	tst     r2,#SA1100_UTSR1_TNF	; TX not full 
    beq     TXBusy
	str		r0,[r1,#SA1100_UTDR]
	ldr     r0,[r1,#SA1100_UTSR1]
    mov     pc, lr
	
    ;; ********************************************************************
	;; PrintWord -- prints the 4 characters in R0
    ;;   r0 contains the binary word
    ;;   r1 contains the base of the serial por
    ;;   writes r0 with RXSTAT, modifies r1,r2,r3,r4
	;; ********************************************************************
PrintWord
	mov	r3, r0
	mov     r4, lr
	bl      PrintChar     
	
	mov     r0,r3,LSR #8    ; shift word right 8 bits
	bl      PrintChar
	
	mov     r0,r3,LSR #16   ; shift word right 16 bits
	bl      PrintChar
	
	mov     r0,r3,LSR #24   ; shift word right 24 bits
	bl      PrintChar

	mov		r0, #CHAR_LF	; #'\r'
	bl		PrintChar

	mov		r0, #CHAR_CR	; #'\n'
	bl		PrintChar
	
    mov     pc, r4

    ;; ********************************************************************
	;; PrintHexWord -- prints the 4 bytes in R0 as 8 hex ascii characters
	;;   followed by a newline
    ;;   r0 contains the binary word
    ;;   r1 contains the base of the serial port
    ;;   Writes r0 with RXSTAT, modifies r1,r2,r3,r4
	;; ********************************************************************
PrintHexWord
	mov     r4, lr
	mov		r3, r0
	mov		r0, r3,LSR #28
	bl      PrintHexNibble     
	mov		r0, r3,LSR #24
	bl      PrintHexNibble     
	mov		r0, r3,LSR #20
	bl      PrintHexNibble     
	mov		r0, r3,LSR #16
	bl      PrintHexNibble     
	mov		r0, r3,LSR #12
	bl      PrintHexNibble     
	mov		r0, r3,LSR #8
	bl      PrintHexNibble     
	mov		r0, r3,LSR #4
	bl      PrintHexNibble     
	mov		r0, r3
	bl      PrintHexNibble     

	mov		r0, #CHAR_LF	; #'\r'
	bl		PrintChar

	mov		r0, #CHAR_CR	; #'\n'
	bl		PrintChar

    mov     pc, r4
	ENDIF

;	ENDP ; void SA11xxAssemblyCodeHolder(void)


;/*+--------------------------------------------------------------------------
;  DESCRIPTION:
;
;	  void Exec(DWORD dwExecutePhysAddr, DWORD dwICMRVirtAddr);
;
;     Allows caller to start executing code at a physical address that is 
;	  passed in.
;	  It turns off interrupts, then MMU and then jumps to the physical address
;	  that is given.
;
;  FORMAL PARAMETERS:
;     dwExecutePhysAddr (IN)	the physical address at which to start 
;								executing code. 
;								This is passed in through r0.
;
;	  dwICMRVirtAddr (IN)		the virtual address at which the ICMR register
;								is located. Allows us to turn of interrupts
;								just before we need to.
;								This is passed in through r1.
;
;  function value or completion codes
;	  This function will not return.
;---------------------------------------------------------------------------*/

	EXPORT	|Exec|						; void Exec(DWORD, DWORD);

	AREA |.text|,CODE

; TEST_DCACHE EQU 1
MMU_OFF	EQU 1

|Exec| PROC	; void Exec(DWORD dwExecutePhysAddr, DWORD dwICMRVirtAddr)

	mov		r12, sp					; save state
	stmdb	sp!, {r0, r1}			; save a local copy of dwExecutePhysAddr, 
									; & dwICMRVirtAddr
	stmdb	sp!, {r12, lr}			; save registers we are going to use

	IF :DEF: MMU_OFF
	mov		r2, r0
	mov		r0, #0
	str		r0, [r1]				; interrupts off

;	mcr		p15, 0, r0, c7, c7, 0	; flush ID cache 

	; At this point we must have everything in registers!
	mcr		p15, 0, r0, c1, c0, 0	; disable MMU 
	mov		r0, r0
	mov		r0, r0
	mov		r0, r0
	mov		r0, r0
	mov     pc, r2					; Jump to physical address dwExecutePhysAddr
	ENDIF

	IF :DEF: TEST_DCACHE
	mov		r4, r0					; save param1 (r0) into r4
	mov		r0, #0					; clear r0
	str		r0, [r1]				; interrupts off

	; DCache flush
	; (See Section 6.2.3 Software Dcache flush in SA-1110 Developers
	; Manual)
	mov		r0, #0x88000000			; A virtual address for 0xe0000000 that 
	add		r0, r0, #0x00c00000		; has B=1/C=1
	add		r1, r0, #8192			; 8KB cache / 32bytes = 256 lines
l10
	ldr		r2, [r0], #32			; load r2 from r0 then r0 = r0 + 32
	teq		r0, r1					; have we reached our limit yet?
	bne		l10						; no, continue until done.

	; Mini DCache flush
	mov		r0, #0x88000000			; A virtual address for 0xe0000000 that 
	add		r0, r0, #0x00d00000		; has B=1/C=0
	add		r1, r0, #512			; 512byte cache / 32 bytes = 16 lines
l20
	ldr		r2, [r0], #32
	teq		r0, r1
	bne		l20

	mov		r0, #0
	mcr		p15, 0, r0, c7, c6, 0	; flush D cache

	mcr		p15, 0, r0, c7, c10, 4	; drain write buffer

;	str		r0, [r4]				; interrupts off
	mcr		p15, 0, r0, c7, c7, 0	; flush ID cache 
	

	; At this point we must have everything in registers!
	mcr		p15, 0, r0, c1, c0, 0	; disable MMU 
	mov		r0, r0
	mov		r0, r0
	mov		r0, r0
	mov		r0, r0
	mov     pc, r4					; Jump to physical address dwExecutePhysAddr
	ENDIF



	; We should never get here!
	ldmia	sp, {sp, pc}			; restore registers and return

	END ; Exec()
	
	END
