/*
 * debug.c - utilities for debugging
 *
 * Copyright (C) 1999 Steve Hill <sjhill@plutonium.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <windows.h>
#include "debug.h"

//----------------------------------------------------------------------
// DebugHostPrint - print debug string back to host environment
//
#ifdef DBG_LOADLCE
int debug_printf(LPCTSTR lpszFmt, ...)
{
	int count;
	va_list ap;
	wchar_t buffer[1024];

	// Get the list of arguments.
	va_start (ap, lpszFmt);
	count = wvsprintf (buffer, lpszFmt, ap);
	va_end (ap);

	// If there is at least one text string, output it.
	if (count > 0)
		OutputDebugStringW (buffer);

	return count;
}
#else
int debug_printf(LPCTSTR lpszFmt, ...)
{
	return 0;
}
#endif

//----------------------------------------------------------------------
// DebugTargPrint - print debug string to a message box on the target
//
#ifdef DBG_LOADLCE
int msg_printf(UINT type, LPCTSTR pszCaption, LPCTSTR lpszFmt, ...)
{
	va_list ap;
	TCHAR buffer[1024];

	// Get the list of arguments.
	va_start (ap, lpszFmt);
	wvsprintf (buffer, lpszFmt, ap);
	va_end (ap);

	// If there is at least one text string, output it.
	return MessageBox(NULL, buffer, pszCaption, type);
}
#else
int msg_printf(UINT type, LPCTSTR pszCaption, LPCTSTR lpszFmt, ...)
{
	return 0;
}
#endif