# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=shared-mime-info
VER=0.51
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${THIS}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`
LIBXML2=`latest --arch=${ARCH} libxml2`
WIN_ICONV=`latest --arch=${ARCH} win-iconv`
ZLIB=`latest --arch=${ARCH} zlib`

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} intltool glib libxml2`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
    [ -d /devel/dist/${ARCH}/$D/share/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/share/pkgconfig:$PKG_CONFIG_PATH
done

MSGFMT=/opt/gnu/bin/msgfmt GMSGFMT=/opt/gnu/bin/msgfmt CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I /devel/dist/${ARCH}/${WIN_ICONV}/include -I /devel/dist/${ARCH}/${LIBXML2}/include " LDFLAGS="-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -L/devel/dist/${ARCH}/${WIN_ICONV}/lib -L/devel/dist/${ARCH}/${LIBXML2}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --prefix=$TARGET &&
make install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

(cd /devel/target/$HEX &&
zip -r -D /tmp/$RUNZIP . &&
zip -d /tmp/$RUNZIP share/pkgconfig/shared-mime-info.pc &&
zip /tmp/$DEVZIP share/pkgconfig/shared-mime-info.pc
)

) 2>&1 | tee /devel/src/tml/make/$THIS.log &&

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
