# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=GConf
VER=2.22.0
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

MINOR=${VER%.*}
MINOR=${MINOR#*.}

(( $MINOR % 2 == 1 )) && UNSTABLE="-unstable"

DEPS=`/devel/src/tml/latest$UNSTABLE.sh glib atk pango gtk+ libIDL ORBit2`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

patch -p0 --verbose <<'EOF'
Index: gconf/gconfd.c
===================================================================
--- gconf/gconfd.c	(revision 2582)
+++ gconf/gconfd.c	(working copy)
@@ -2434,6 +2434,8 @@
   CORBA_Object_release (old_client, &ev);
   CORBA_exception_free (&ev);
 
+  gconf_log (GCL_DEBUG, "Removed a client");
+
   return;
   
  notfound:
Index: gconf/dllmain.c
===================================================================
--- gconf/dllmain.c	(revision 2582)
+++ gconf/dllmain.c	(working copy)
@@ -68,11 +68,10 @@
 static void
 setup (void)
 {
-  char *full_prefix;
+  char *full_prefix = NULL;
   char *cp_prefix; 
 
   wchar_t wcbfr[1000];
-  char cpbfr[1000];
   
   G_LOCK (mutex);
   if (locale_dir != NULL)
@@ -81,27 +80,14 @@
       return;
     }
 
-  if (G_WIN32_HAVE_WIDECHAR_API ())
+  if (GetModuleFileNameW (hmodule, wcbfr, G_N_ELEMENTS (wcbfr)))
     {
-      /* NT-based Windows has wide char API */
-      if (GetModuleFileNameW (hmodule, wcbfr, G_N_ELEMENTS (wcbfr)))
-	{
-	  full_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
-	  if (GetShortPathNameW (wcbfr, wcbfr, G_N_ELEMENTS (wcbfr)))
-	    cp_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
-	  else if (full_prefix)
-	    cp_prefix = g_locale_from_utf8 (full_prefix, -1, NULL, NULL, NULL);
-	}
+      full_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
+      if (GetShortPathNameW (wcbfr, wcbfr, G_N_ELEMENTS (wcbfr)))
+	cp_prefix = g_utf16_to_utf8 (wcbfr, -1, NULL, NULL, NULL);
+      else if (full_prefix)
+	cp_prefix = g_locale_from_utf8 (full_prefix, -1, NULL, NULL, NULL);
     }
-  else
-    {
-      /* Win9x */
-      if (GetModuleFileNameA (hmodule, cpbfr, G_N_ELEMENTS (cpbfr)))
-	{
-	  full_prefix = g_locale_to_utf8 (cpbfr, -1, NULL, NULL, NULL);
-	  cp_prefix = g_strdup (cpbfr);
-	}
-    }
 
   if (full_prefix != NULL)
     {
Index: gconf/gconf-internals.c
===================================================================
--- gconf/gconf-internals.c	(revision 2582)
+++ gconf/gconf-internals.c	(working copy)
@@ -38,7 +38,7 @@
 
 #ifdef G_OS_WIN32
 #include <windows.h>
-#include <share.h>
+#include <io.h>
 #define pipe(fds) _pipe(fds, 4096, _O_BINARY)
 #endif
 
@@ -2247,8 +2247,6 @@
 #endif
 }
 
-#endif
-
 #ifdef F_SETLK
 /* Your basic Stevens cut-and-paste */
 static int
@@ -2301,8 +2299,6 @@
 #endif
 }
 
-#ifndef G_OS_WIN32
-
 static char*
 unique_filename (const char *directory)
 {
@@ -2382,21 +2378,20 @@
 
 #else
 
-  if (G_WIN32_HAVE_WIDECHAR_API ())
-    {
-      wchar_t *wfilename = g_utf8_to_utf16 (filename, -1, NULL, NULL, NULL);
-      fd = _wsopen (wfilename, O_WRONLY|O_CREAT|O_EXCL, SH_DENYWR, 0700);
-      g_free (wfilename);
-    }
-  else
-    {
-      char *cpfilename = g_locale_from_utf8 (filename, -1, NULL, NULL, NULL);
-      fd = _sopen (cpfilename, O_WRONLY|O_CREAT|O_EXCL, SH_DENYWR, 0700);
-      g_free (cpfilename);
-    }
+  wchar_t *wfilename = g_utf8_to_utf16 (filename, -1, NULL, NULL, NULL);
 
+  fd = _wopen (wfilename, O_WRONLY|O_CREAT|O_NOINHERIT|O_EXCL, 0700);
+  g_free (wfilename);
+
   got_lock = (fd >= 0);
 
+  if (!got_lock)
+    g_set_error (err,
+		 GCONF_ERROR,
+		 GCONF_ERROR_LOCK_FAILED,
+		 _("Could not create file '%s', probably because it already exists"),
+		 filename);
+
 #endif
 
   if (!got_lock)
@@ -2685,6 +2680,8 @@
   retval = FALSE;
   uniquefile = NULL;
   
+#ifndef G_OS_WIN32
+
   /* A paranoia check to avoid disaster if e.g.
    * some random client code opened and closed the
    * lockfile (maybe Nautilus checking its MIME type or
@@ -2701,8 +2698,6 @@
       goto out;
     }
 
-#ifndef G_OS_WIN32
-
   /* To avoid annoying .nfs3435314513453145 files on unlink, which keep us
    * from removing the lock directory, we don't want to hold the
    * lockfile open after removing all links to it. But we can't
@@ -2737,6 +2732,16 @@
       goto out;
     }
 
+#else
+
+  /* On Windows we just truncate the file to zero size as we can't
+   * easily rename or unlink it while it is open. This is to avoid
+   * race conditions, as we don't want the file to exist but with
+   * seemingly valid contents between closing and unlinking.
+   */
+  if (lock->lock_fd >= 0)
+    chsize (lock->lock_fd, 0);
+
 #endif
 
   /* Now drop our lock */
@@ -2760,6 +2765,19 @@
       goto out;
     }
 
+#else
+
+  if (g_unlink (lock->iorfile) < 0)
+    {
+      g_set_error (err,
+                   GCONF_ERROR,
+                   GCONF_ERROR_FAILED,
+                   _("Failed to clean up file '%s': %s"),
+                   lock->iorfile, g_strerror (errno));
+
+      goto out;
+    }
+
 #endif
 
   /* And finally clean up the directory - this would have failed if
EOF


PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3' CPPFLAGS='-I/opt/gnu/include -I/devel/dist/popt-1.10.2-tml-20050828/include' LDFLAGS='-Wl,--enable-runtime-pseudo-reloc -L/opt/gnu/lib -L/devel/dist/popt-1.10.2-tml-20050828/lib' CFLAGS=-O ./configure  --enable-debug=yes --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX &&
unset MY_PKG_CONFIG_PATH &&

libtoolcacheize &&
PATH=/devel/target/$HEX/bin:.libs:$PATH make install &&

PATH=/devel/target/$HEX/bin:$PATH make check &&

./gconf-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
