/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.resources.FontUtils;

public class TimePicker
extends PopupDialog {
    public static final int DELETE = 100;
    private Control hostControl;
    private Combo year;
    private Combo month;
    private Combo day;
    private Combo hour;
    private Combo minute;
    private Button todayButton;
    private Button noneButton;
    private Button cancelButton;
    private Button okButton;
    private Calendar calendar;
    private Color backgroundColor;
    private boolean refreshingCombos = false;

    public TimePicker(Shell parent, Control hostControl) {
        super(parent, 8, true, false, false, false, false, null, null);
        this.hostControl = hostControl;
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        this.backgroundColor = parent.getDisplay().getSystemColor(25);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createDateCombos(composite);
        this.createTimeCombos(composite);
        Label sep = new Label(composite, 258);
        sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createButtons(composite);
        return composite;
    }

    public void create() {
        super.create();
        this.refreshCombos();
    }

    private void createButtons(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        bar.setLayout((Layout)gridLayout);
        Composite container = new Composite(bar, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 5;
        gridLayout2.horizontalSpacing = 5;
        container.setLayout((Layout)gridLayout2);
        this.todayButton = this.createButton(container, TaskMessages.TimePicker_Today_text);
        this.todayButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimePicker.this.getCalendar().setTime(TimePicker.this.createToday().getTime());
                TimePicker.this.refreshCombos();
            }
        });
        this.noneButton = this.createButton(container, TaskMessages.TimePicker_None_text);
        this.noneButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimePicker.this.setReturnCode(100);
                TimePicker.this.close();
            }
        });
        this.cancelButton = this.createButton(container, IDialogConstants.CANCEL_LABEL);
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimePicker.this.setReturnCode(1);
                TimePicker.this.close();
            }
        });
        this.okButton = this.createButton(container, IDialogConstants.OK_LABEL);
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TimePicker.this.setReturnCode(0);
                TimePicker.this.close();
            }
        });
        this.getShell().setDefaultButton(this.okButton);
        this.setMaxWidth(this.todayButton, this.noneButton, this.cancelButton, this.okButton);
    }

    private void setMaxWidth(Button ... buttons) {
        Button b;
        int width = 50;
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            width = Math.max(width, b.computeSize((int)-1, (int)-1).x);
            ++n2;
        }
        buttonArray = buttons;
        n = buttons.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            ((GridData)b.getLayoutData()).widthHint = width;
            ++n2;
        }
    }

    protected Color getBackground() {
        return this.backgroundColor;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void createDateCombos(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(TaskMessages.TimePicker_Date_label);
        this.year = this.createCombo(composite, true);
        int y = 1970;
        while (y < 2050) {
            this.year.add(String.valueOf(y));
            ++y;
        }
        this.year.setVisibleItemCount(20);
        Label slash1 = new Label(composite, 0);
        slash1.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        slash1.setText("/");
        this.month = this.createCombo(composite, true);
        int m = 1;
        while (m <= 12) {
            this.month.add(String.valueOf(m));
            ++m;
        }
        this.month.setVisibleItemCount(12);
        Label slash2 = new Label(composite, 0);
        slash2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        slash2.setText("/");
        this.day = this.createCombo(composite, true);
        int d = 1;
        while (d <= 31) {
            this.day.add(String.valueOf(d));
            ++d;
        }
        this.day.setVisibleItemCount(15);
    }

    private void createTimeCombos(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(TaskMessages.TimePicker_Time_label);
        this.hour = this.createCombo(composite, true);
        int h = 0;
        while (h < 24) {
            this.hour.add(String.valueOf(h));
            ++h;
        }
        this.hour.setVisibleItemCount(20);
        Label colon = new Label(composite, 0);
        colon.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        colon.setText(":");
        this.minute = this.createCombo(composite, true);
        int m = 0;
        while (m < 60) {
            this.minute.add(String.valueOf(m));
            m += 5;
        }
        this.minute.setVisibleItemCount(20);
    }

    private Combo createCombo(Composite parent, boolean modifiable) {
        Combo combo = new Combo(parent, 0x804 | (modifiable ? 0 : 8));
        combo.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        combo.setLayoutData((Object)new GridData(4, 4, false, false));
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimePicker.this.refreshCalendar();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TimePicker.this.refreshCalendar();
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TimePicker.this.refreshingCombos) {
                    return;
                }
                TimePicker.this.refreshCalendar();
            }
        });
        return combo;
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = this.createToday();
        }
        return this.calendar;
    }

    private Calendar createToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, calendar.get(12) / 5 * 5);
        return calendar;
    }

    public Date getDate() {
        return this.getCalendar().getTime();
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        this.getCalendar().setTime(date);
        this.refreshCombos();
    }

    private void refreshCombos() {
        int m;
        int index;
        this.refreshingCombos = true;
        if (this.year != null) {
            int y = this.getCalendar().get(1);
            index = y - 1970;
            if (index >= 0 && index < this.year.getItemCount()) {
                this.year.select(index);
            }
            this.year.setText(String.valueOf(y));
        }
        if (this.month != null) {
            m = this.getCalendar().get(2);
            this.month.select(m);
            this.month.setText(String.valueOf(m + 1));
        }
        if (this.day != null) {
            int d = this.getCalendar().get(5);
            this.day.select(d - 1);
            this.day.setText(String.valueOf(d));
        }
        if (this.hour != null) {
            int h = this.getCalendar().get(11);
            this.hour.select(h);
            this.hour.setText(String.valueOf(h));
        }
        if (this.minute != null) {
            m = this.getCalendar().get(12);
            index = m / 5;
            this.minute.select(index);
            this.minute.setText(String.valueOf(m));
        }
        this.refreshingCombos = false;
    }

    private void refreshCalendar() {
        this.setField(1, this.year, 1970, 1);
        this.setField(2, this.month, 0, 1);
        this.setField(5, this.day, 1, 1);
        this.setField(11, this.hour, 0, 1);
        this.setField(12, this.minute, 0, 5);
    }

    private void setField(int field, Combo combo, int base, int times) {
        int index = combo.getSelectionIndex();
        if (index >= 0) {
            this.getCalendar().set(field, index * times + base);
            return;
        }
        String text = combo.getText();
        if (text != null) {
            try {
                int value = Integer.parseInt(text);
                this.getCalendar().set(field, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public int open() {
        int retCode = super.open();
        this.setReturnCode(1);
        if (retCode == 0) {
            this.runEventLoop(this.getShell());
        }
        return this.getReturnCode();
    }

    private void runEventLoop(Shell loopShell) {
        Display display = this.getShell() == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                TaskInfo.log(e);
            }
        }
        display.update();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.hostControl.toDisplay(0, 0);
        p.y += this.hostControl.getBounds().height;
        return p;
    }
}

