/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.decorations.IBoundaryDecoration;
import org.xmind.ui.internal.figures.BoundaryFigure;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.style.StyleUtils;

public class BoundaryDecorator
extends Decorator {
    private static final BoundaryDecorator instance = new BoundaryDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        if (figure instanceof BoundaryFigure) {
            this.decorateBoundary(part, (BoundaryFigure)figure);
        }
    }

    private void decorateBoundary(IGraphicalPart part, BoundaryFigure figure) {
        IStyleSelector ss;
        String newShapeId;
        IBoundaryDecoration shape = figure.getDecoration();
        if (!StyleUtils.isSameDecoration((IDecoration)shape, newShapeId = StyleUtils.getString(part, ss = StyleUtils.getStyleSelector(part), "shape-class", "org.xmind.boundaryShape.roundedRect"))) {
            shape = StyleUtils.createBoundaryDecoration(part, newShapeId);
            figure.setDecoration(shape);
        }
        if (shape != null) {
            String decorationId = shape.getId();
            shape.setAlpha((IFigure)figure, 255);
            int fillAlpha = StyleUtils.getAlpha(part, ss, 128);
            shape.setFillAlpha((IFigure)figure, fillAlpha);
            shape.setFillColor((IFigure)figure, StyleUtils.getColor(part, ss, "svg:fill", decorationId, "#ffffff"));
            shape.setGradient((IFigure)figure, false);
            shape.setLineAlpha((IFigure)figure, 255);
            shape.setLineColor((IFigure)figure, StyleUtils.getColor(part, ss, "line-color", decorationId, "#afafaf"));
            shape.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(part, ss, decorationId, 2));
            shape.setLineWidth((IFigure)figure, StyleUtils.getInteger(part, ss, "line-width", decorationId, 3));
            shape.setVisible((IFigure)figure, true);
            if (shape instanceof ICorneredDecoration) {
                ((ICorneredDecoration)shape).setCornerSize((IFigure)figure, StyleUtils.getInteger(part, ss, "shape-corner", decorationId, 10));
            }
        }
        this.decorateVisible(part, figure);
    }

    private void decorateVisible(IGraphicalPart part, BoundaryFigure figure) {
        figure.setVisible(this.isBoundaryFigureVisible(part, figure));
    }

    private boolean isBoundaryFigureVisible(IGraphicalPart part, BoundaryFigure figure) {
        if (part instanceof IBoundaryPart) {
            IBoundaryPart boundary = (IBoundaryPart)part;
            if (boundary.getBoundary().isMasterBoundary()) {
                return true;
            }
            List<IBranchPart> branches = boundary.getEnclosingBranches();
            for (IBranchPart branch : branches) {
                if (!branch.getFigure().isShowing()) continue;
                return true;
            }
        }
        return false;
    }

    public static BoundaryDecorator getInstance() {
        return instance;
    }
}

