/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.IFileEntry;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponentRefManager;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.HyperlinkUtils;

public class InternalHyperlinkUtils {
    private static boolean isInWorkingRevision(IAdaptable object) {
        Element docEle;
        Document doc;
        Node node = object.getAdapter(Node.class);
        if (node != null && (doc = DOMUtils.getOwnerDocument(node)) != null && (docEle = doc.getDocumentElement()) != null) {
            return !"xmap-revision-content".equals(docEle.getNodeName());
        }
        return true;
    }

    public static void activateHyperlink(IWorkbook workbook, String url, IAdaptable source) {
        if (workbook != null) {
            if (HyperlinkUtils.isAttachmentURL(url)) {
                if (InternalHyperlinkUtils.isInWorkingRevision(source)) {
                    String attPath = HyperlinkUtils.toAttachmentPath(url);
                    InternalHyperlinkUtils.increaseFileEntryRef(workbook, attPath);
                }
            } else if (HyperlinkUtils.isInternalURL(url) && source instanceof IIdentifiable) {
                String sourceId = ((IIdentifiable)((Object)source)).getId();
                String id = HyperlinkUtils.toElementID(url);
                InternalHyperlinkUtils.increateElementRef(workbook, id, sourceId);
            }
        }
    }

    public static void increaseFileEntryRef(IWorkbook workbook, String entryPath) {
        IFileEntry e;
        if (workbook != null && entryPath != null && (e = workbook.getManifest().getFileEntry(entryPath)) != null) {
            e.increaseReference();
            if (e.isDirectory()) {
                for (IFileEntry sub : e.getSubEntries()) {
                    sub.increaseReference();
                }
            }
        }
    }

    public static void increateElementRef(IWorkbook workbook, String elementId, String sourceId) {
        IWorkbookComponentRefManager counter;
        if (workbook != null && elementId != null && (counter = workbook.getAdapter(IWorkbookComponentRefManager.class)) != null) {
            counter.increaseRef(sourceId, elementId);
        }
    }

    public static void deactivateHyperlink(IWorkbook workbook, String url, IAdaptable source) {
        if (workbook != null) {
            if (HyperlinkUtils.isAttachmentURL(url)) {
                if (InternalHyperlinkUtils.isInWorkingRevision(source)) {
                    String attPath = HyperlinkUtils.toAttachmentPath(url);
                    InternalHyperlinkUtils.decreaseFileEntryRef(workbook, attPath);
                }
            } else if (HyperlinkUtils.isInternalURL(url) && source instanceof IIdentifiable) {
                String sourceId = ((IIdentifiable)((Object)source)).getId();
                String elementId = HyperlinkUtils.toElementID(url);
                InternalHyperlinkUtils.decreaseElementRef(workbook, elementId, sourceId);
            }
        }
    }

    public static void decreaseFileEntryRef(IWorkbook workbook, String entryPath) {
        IFileEntry e;
        if (workbook != null && entryPath != null && (e = workbook.getManifest().getFileEntry(entryPath)) != null) {
            e.decreaseReference();
            if (e.isDirectory()) {
                for (IFileEntry sub : e.getSubEntries()) {
                    sub.decreaseReference();
                }
            }
        }
    }

    public static void decreaseElementRef(IWorkbook workbook, String elementId, String sourceId) {
        IWorkbookComponentRefManager counter;
        if (workbook != null && elementId != null && (counter = workbook.getAdapter(IWorkbookComponentRefManager.class)) != null) {
            counter.decreaseRef(sourceId, elementId);
        }
    }

    public static String importAttachmentURL(String sourceHyperlink, IWorkbook sourceWorkbook, IWorkbook targetWorkbook) throws IOException {
        String sourcePath = HyperlinkUtils.toAttachmentPath(sourceHyperlink);
        String targetPath = InternalHyperlinkUtils.importAttachment(sourcePath, sourceWorkbook, targetWorkbook);
        return HyperlinkUtils.toAttachmentURL(targetPath);
    }

    public static String importAttachment(String sourcePath, IWorkbook sourceWorkbook, IWorkbook targetWorkbook) throws IOException {
        IManifest manifest;
        IFileEntry targetEntry;
        IFileEntry sourceEntry = sourceWorkbook.getManifest().getFileEntry(sourcePath);
        if (sourceEntry != null && (targetEntry = (manifest = targetWorkbook.getManifest()).cloneEntryAsAttachment(sourceEntry)) != null) {
            return targetEntry.getPath();
        }
        return sourcePath;
    }
}

