/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.resources.ImageDescriptorProvider;
import org.xmind.ui.viewers.IToolTipProvider;
import org.xmind.ui.viewers.MButton;
import org.xmind.ui.viewers.SWTUtils;

public class MComboViewer
extends StructuredViewer {
    public static final int NORMAL = 0;
    public static final int NO_TEXT = 1;
    public static final int NO_IMAGE = 2;
    public static final int FILTERED = 1024;
    private static final List EMPTY_LIST = Collections.emptyList();
    private MButton dropDownHandle;
    private final boolean filtered;
    private List<Object> elementList = new ArrayList<Object>();
    private Object selection = null;
    private MenuManager popupMenu = null;
    private Map<Object, IAction> actionMap = null;
    private PopupFilteredList popupList = null;
    private PopupFilteredList.PatternFilter patternFilter = null;
    private boolean permitsUnprovidedElement = false;
    private Object emptySelectionImitation = null;
    private Object separatorImitation = null;
    private ILabelProvider handleLabelProvider = null;
    private ILabelProviderListener handleLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (MComboViewer.this.getControl() == null || MComboViewer.this.getControl().isDisposed()) {
                return;
            }
            MComboViewer.this.handleLabelProviderChanged(event);
        }
    };

    public MComboViewer(Composite parent, int style) {
        this.dropDownHandle = this.createDropDownHandle(parent, style);
        this.hookControl(this.dropDownHandle.getControl());
        this.dropDownHandle.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MComboViewer.this.openPopup();
            }
        });
        this.filtered = (style & 0x400) != 0;
    }

    protected MButton createDropDownHandle(Composite parent, int style) {
        return new MButton(parent, style);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        MComboViewer.this.handleKeyPress(event);
                    }
                }
            }
        };
        control.addListener(1, listener);
    }

    protected void handleKeyPress(Event e) {
        if (!this.dropDownHandle.getControl().isEnabled()) {
            return;
        }
        int stateMask = e.stateMask;
        int keyCode = e.keyCode;
        if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000001)) {
            this.selectPrevious();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000002)) {
            this.selectNext();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000007)) {
            this.selectFirst();
        } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000008)) {
            this.selectLast();
        }
    }

    protected void selectPrevious() {
        if (this.hasNoElement()) {
            return;
        }
        int index = this.getSelectionIndex();
        if (index > 0 && index < this.getItemCount()) {
            this.setSelection((ISelection)new StructuredSelection(this.elementList.get(index - 1)));
        }
    }

    protected void selectNext() {
        if (this.hasNoElement()) {
            return;
        }
        int index = this.getSelectionIndex();
        if (index >= 0 && index < this.getItemCount() - 1) {
            this.setSelection((ISelection)new StructuredSelection(this.elementList.get(index + 1)));
        }
    }

    protected void selectFirst() {
        if (this.hasNoElement()) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(this.elementList.get(0)));
    }

    protected void selectLast() {
        if (this.hasNoElement()) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(this.elementList.get(this.getItemCount() - 1)));
    }

    protected boolean hasNoElement() {
        return this.elementList.isEmpty();
    }

    protected int getItemCount() {
        return this.elementList.size();
    }

    protected int getSelectionIndex() {
        if (this.getCurrentSelection() == null || this.hasNoElement()) {
            return -1;
        }
        return this.indexForElement(this.getCurrentSelection());
    }

    protected int indexForElement(Object element) {
        ViewerComparator comparator = this.getComparator();
        if (comparator == null) {
            return this.elementList.indexOf(element);
        }
        int count = this.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.elementList.get(mid);
            int compare = comparator.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.elementList.get(mid);
                    compare = comparator.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.closePopup();
        this.elementList.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        Object newSelection = null;
        int i = 0;
        while (i < size) {
            Object el = children[i];
            this.elementList.add(el);
            this.mapElement(el, (Widget)this.getControl());
            if (this.selection != null && this.equals(this.selection, el)) {
                newSelection = el;
            }
            ++i;
        }
        this.selection = newSelection;
        this.updateDropDown();
        if (this.popupMenu != null) {
            this.refreshPopupMenu(this.popupMenu);
        } else if (this.popupList != null) {
            this.refreshPopupList(this.popupList);
        }
    }

    protected Widget doFindInputItem(Object element) {
        return this.dropDownHandle.getControl();
    }

    protected Widget doFindItem(Object element) {
        return this.dropDownHandle.getControl();
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.equals(element, this.getRoot()) || this.equals(element, this.getCurrentSelection())) {
            this.updateDropDown();
        }
        if (this.popupMenu != null) {
            this.updateAction(element);
        }
    }

    protected void updateAction(Object element) {
        if (this.actionMap == null) {
            return;
        }
        IAction action = this.actionMap.get(element);
        if (action == null) {
            return;
        }
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        this.updateAction(action, labelProvider, element);
    }

    protected void updateAction(IAction action, ILabelProvider labelProvider, Object element) {
        String text = labelProvider.getText(element);
        if (text == null) {
            text = "";
        }
        action.setText(text);
        if (labelProvider instanceof ImageDescriptorProvider) {
            action.setImageDescriptor(((ImageDescriptorProvider)labelProvider).getImageDescriptor(element));
        } else {
            final Image image = labelProvider.getImage(element);
            if (image != null) {
                action.setImageDescriptor(new ImageDescriptor(){

                    public ImageData getImageData() {
                        return image.getImageData();
                    }
                });
            } else {
                action.setImageDescriptor(null);
            }
        }
    }

    protected List getSelectionFromWidget() {
        return this.getCurrentSelection() == null ? EMPTY_LIST : Collections.singletonList(this.getCurrentSelection());
    }

    protected void internalRefresh(Object element) {
        if (this.equals(element, this.getRoot())) {
            this.updateDropDown();
            if (this.popupMenu != null) {
                this.refreshPopupMenu(this.popupMenu);
            } else if (this.popupList != null) {
                this.refreshPopupList(this.popupList);
            }
        } else {
            if (this.equals(element, this.getCurrentSelection())) {
                this.updateDropDown();
            }
            if (this.popupMenu != null) {
                this.updateAction(element);
            }
        }
    }

    protected void updateDropDown() {
        String text = null;
        Image image = null;
        Color textFg = null;
        Color textBg = null;
        Point imageSize = null;
        Object currentSelection = this.getCurrentSelection();
        ILabelProvider labelProvider = (ILabelProvider)this.getWorkingHandleLabelProvider(ILabelProvider.class);
        if (labelProvider != null) {
            if (currentSelection == null) {
                currentSelection = this.emptySelectionImitation;
            }
            if (currentSelection != null) {
                text = labelProvider.getText(currentSelection);
                image = labelProvider.getImage(currentSelection);
            }
            if (!this.hasNoElement()) {
                for (Object element : this.elementList) {
                    Image i = labelProvider.getImage(element);
                    if (i == null) continue;
                    Rectangle b = i.getBounds();
                    imageSize = MComboViewer.union(imageSize, b.width, b.height);
                }
            }
        }
        if (currentSelection != null) {
            IToolTipProvider toolTipProvider;
            IColorProvider colorProvider = (IColorProvider)this.getWorkingHandleLabelProvider(IColorProvider.class);
            if (colorProvider != null) {
                textFg = colorProvider.getForeground(currentSelection);
                textBg = colorProvider.getBackground(currentSelection);
            }
            if ((toolTipProvider = (IToolTipProvider)this.getWorkingHandleLabelProvider(IToolTipProvider.class)) != null) {
                String tooltip = toolTipProvider.getToolTip(currentSelection);
                this.dropDownHandle.getControl().setToolTipText(tooltip);
            }
        }
        this.dropDownHandle.setText(text);
        this.dropDownHandle.setImage(image);
        this.dropDownHandle.setImageSize(imageSize);
        this.dropDownHandle.setTextForeground(textFg);
        this.dropDownHandle.setTextBackground(textBg);
    }

    private Object getWorkingHandleLabelProvider(Class<?> type) {
        if (this.handleLabelProvider != null && type.isInstance(this.handleLabelProvider)) {
            return this.handleLabelProvider;
        }
        if (this.getLabelProvider() != null && type.isInstance(this.getLabelProvider())) {
            return this.getLabelProvider();
        }
        return null;
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        this.selection = l != null && !l.isEmpty() ? l.get(0) : null;
        this.updateDropDown();
        if (this.popupMenu != null) {
            this.setSelectionToMenu(this.popupMenu);
        } else if (this.popupList != null) {
            this.popupList.setDefaultSelection(this.selection);
        }
    }

    public Control getControl() {
        return this.dropDownHandle.getControl();
    }

    public Object getCurrentSelection() {
        return this.selection;
    }

    public PopupFilteredList getPopupList() {
        return this.popupList;
    }

    public Menu getMenu() {
        return this.popupMenu == null ? null : this.popupMenu.getMenu();
    }

    public void open() {
        this.openPopup();
    }

    protected void openPopup() {
        if (this.filtered) {
            if (this.popupList == null) {
                this.popupList = this.createPopupList();
            }
            if (this.popupList != null) {
                this.openPopupList(this.popupList);
            }
        } else {
            if (this.popupMenu == null) {
                this.popupMenu = this.createPopupMenu();
            }
            if (this.popupMenu != null) {
                this.openPopupMenu(this.popupMenu);
            }
        }
    }

    protected void openPopupMenu(MenuManager menuManager) {
        Menu menu = menuManager.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (menu.isVisible()) {
                menu.setVisible(false);
            } else {
                this.locatePopupMenu(menu);
                menu.setVisible(true);
            }
        }
    }

    protected MenuManager createPopupMenu() {
        MenuManager popupMenu = new MenuManager();
        this.refreshPopupMenu(popupMenu);
        popupMenu.createContextMenu(this.getControl());
        return popupMenu;
    }

    protected void refreshPopupMenu(MenuManager menuManager) {
        menuManager.removeAll();
        if (this.actionMap == null) {
            this.actionMap = new HashMap<Object, IAction>();
        } else {
            this.actionMap.clear();
        }
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        for (Object element : this.elementList) {
            if (this.separatorImitation != null && element == this.separatorImitation) {
                menuManager.add((IContributionItem)new Separator());
                continue;
            }
            Object action = this.actionMap.get(element);
            if (action == null) {
                action = new SelectionAction(element);
                action.setChecked(false);
                this.actionMap.put(element, (IAction)action);
            }
            this.updateAction((IAction)action, labelProvider, element);
            menuManager.add(action);
        }
        this.setSelectionToMenu(menuManager);
    }

    protected void locatePopupMenu(Menu menu) {
        Rectangle r;
        if (this.getControl() instanceof Composite) {
            r = ((Composite)this.getControl()).getClientArea();
        } else {
            r = this.getControl().getBounds();
            r.y = 0;
            r.x = 0;
        }
        Point loc = this.getControl().toDisplay(r.x, r.y);
        loc.y += r.height;
        menu.setLocation(loc);
    }

    protected PopupFilteredList createPopupList() {
        PopupFilteredList list = new PopupFilteredList(this.getControl().getShell());
        this.refreshPopupList(list);
        list.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                MComboViewer.this.setSelection(event.getSelection());
            }
        });
        return list;
    }

    protected void refreshPopupList(PopupFilteredList list) {
        list.setPermitsUnprovidedElement(this.permitsUnprovidedElement());
        list.setPatternFilter(this.getPatternFilter());
        list.setContentProvider(this.getContentProvider());
        list.setLabelProvider(this.getLabelProvider());
        list.setFilters(this.getFilters());
        list.setSorter(this.getSorter());
        list.setComparator(this.getComparator());
        list.setComparer(this.getComparer());
        list.setDefaultSelection(this.getCurrentSelection());
        list.setInput(this.getInput());
    }

    protected void openPopupList(PopupFilteredList list) {
        this.locatePopupList(list);
        list.open();
        Shell shell = list.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.dropDownHandle.setForceFocus(true);
            shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (!MComboViewer.this.dropDownHandle.getControl().isDisposed()) {
                        MComboViewer.this.dropDownHandle.setForceFocus(false);
                    }
                }
            });
        }
    }

    protected void locatePopupList(PopupFilteredList list) {
        Rectangle r;
        if (this.getControl() instanceof Composite) {
            r = ((Composite)this.getControl()).getClientArea();
        } else {
            r = this.getControl().getBounds();
            r.y = 0;
            r.x = 0;
        }
        Point loc = this.getControl().toDisplay(r.x, r.y);
        r.x = loc.x;
        r.y = loc.y;
        list.setBoundsReference(r);
    }

    protected void closePopup() {
        Menu menu;
        if (this.popupMenu != null && (menu = this.popupMenu.getMenu()) != null && !menu.isDisposed()) {
            menu.setVisible(false);
        }
        if (this.popupList != null) {
            this.popupList.close();
        }
    }

    protected void setSelectionToMenu(MenuManager menuManager) {
        int index = this.getSelectionIndex();
        Menu menu = menuManager.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (index < 0 || index >= menu.getItemCount()) {
                menu.setDefaultItem(null);
            } else {
                menu.setDefaultItem(menu.getItem(index));
            }
        }
        if (this.actionMap != null) {
            for (Object element : this.elementList) {
                IAction action = this.actionMap.get(element);
                if (action == null) continue;
                action.setChecked(this.equals(element, this.getCurrentSelection()));
            }
        }
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.handleLabelProvider != null) {
            this.handleLabelProvider.removeListener(this.handleLabelProviderListener);
            this.handleLabelProvider.dispose();
            this.handleLabelProvider = null;
        }
        super.handleDispose(event);
        this.closePopup();
        this.popupList = null;
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
            this.actionMap = null;
        }
    }

    public boolean permitsUnprovidedElement() {
        return this.permitsUnprovidedElement;
    }

    public void setPermitsUnprovidedElement(boolean permitsUnprovidedElement) {
        if (permitsUnprovidedElement == this.permitsUnprovidedElement) {
            return;
        }
        this.permitsUnprovidedElement = permitsUnprovidedElement;
        if (this.popupList != null) {
            this.popupList.setPermitsUnprovidedElement(permitsUnprovidedElement);
        }
    }

    public PopupFilteredList.PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public void setPatternFilter(PopupFilteredList.PatternFilter patternFilter) {
        if (patternFilter == this.patternFilter) {
            return;
        }
        this.patternFilter = patternFilter;
        if (this.popupList != null) {
            this.popupList.setPatternFilter(patternFilter);
        }
    }

    protected static Point union(Point size, int width, int height) {
        if (size == null) {
            return new Point(width, height);
        }
        size.x = Math.max(size.x, width);
        size.y = Math.max(size.y, height);
        return size;
    }

    public Object getEmptySelectionImitation() {
        return this.emptySelectionImitation;
    }

    public void setEmptySelectionImitation(Object emptySelectionSubstitution) {
        this.emptySelectionImitation = emptySelectionSubstitution;
    }

    public Object getSeparatorImitation() {
        return this.separatorImitation;
    }

    public void setSeparatorImitation(Object separatorImitation) {
        this.separatorImitation = separatorImitation;
    }

    public void setEnabled(boolean enabled) {
        this.dropDownHandle.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.dropDownHandle.isEnabled();
    }

    public boolean isDropDownVisible() {
        if (this.filtered) {
            return this.popupList != null && this.popupList.getShell() != null && !this.popupList.getShell().isDisposed() && this.popupList.getShell().isVisible();
        }
        return this.popupMenu != null && this.popupMenu.getMenu() != null && !this.popupMenu.getMenu().isDisposed() && this.popupMenu.getMenu().isVisible();
    }

    public ILabelProvider getHandleLabelProvider() {
        return this.handleLabelProvider;
    }

    public void setHandleLabelProvider(ILabelProvider labelProvider) {
        ILabelProvider oldLabelProvider = this.handleLabelProvider;
        if (oldLabelProvider == labelProvider) {
            return;
        }
        if (oldLabelProvider != null) {
            oldLabelProvider.removeListener(this.handleLabelProviderListener);
        }
        this.handleLabelProvider = labelProvider;
        if (labelProvider != null) {
            labelProvider.addListener(this.handleLabelProviderListener);
        }
        this.refresh();
        if (oldLabelProvider != null) {
            oldLabelProvider.dispose();
        }
    }

    public void setHandlePaddings(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        if (this.dropDownHandle != null) {
            this.dropDownHandle.setPaddings(leftPadding, topPadding, rightPadding, bottomPadding);
        }
    }

    public void setHandleHorizontalPaddings(int leftPadding, int rightPadding) {
        if (this.dropDownHandle != null) {
            this.dropDownHandle.setHorizontalPaddings(leftPadding, rightPadding);
        }
    }

    public void setHandleVerticalPaddings(int topPadding, int bottomPadding) {
        if (this.dropDownHandle != null) {
            this.dropDownHandle.setVerticalPaddings(topPadding, bottomPadding);
        }
    }

    public int getHandleLeftPadding() {
        int leftPadding = 0;
        if (this.dropDownHandle != null) {
            leftPadding = this.dropDownHandle.getLeftPadding();
        }
        return leftPadding;
    }

    public int getHandleTopPadding() {
        int topPadding = 0;
        if (this.dropDownHandle != null) {
            topPadding = this.dropDownHandle.getTopPadding();
        }
        return topPadding;
    }

    public int getHandleRightPadding() {
        int rightPadding = 0;
        if (this.dropDownHandle != null) {
            rightPadding = this.dropDownHandle.getRightPadding();
        }
        return rightPadding;
    }

    public int getHandleBottomPadding() {
        int bottomPadding = 0;
        if (this.dropDownHandle != null) {
            bottomPadding = this.dropDownHandle.getBottomPadding();
        }
        return bottomPadding;
    }

    private class SelectionAction
    extends Action {
        private Object element;

        public SelectionAction(Object element) {
            this.element = element;
        }

        public void run() {
            super.run();
            MComboViewer.this.setSelection((ISelection)new StructuredSelection(this.element));
        }
    }
}

