/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Vector;
import weka.gui.treevisualizer.Node;

public class Edge {
    private final String m_label;
    private String m_rsource;
    private String m_rtarget;
    private Node m_source;
    private Node m_target;
    private final Vector<String> m_lines;

    public Edge(String label, String source, String target) {
        this.m_label = label;
        this.m_rsource = source;
        this.m_rtarget = target;
        this.m_lines = new Vector(3, 2);
        this.breakupLabel();
    }

    public String getLabel() {
        return this.m_label;
    }

    private void breakupLabel() {
        int noa;
        int prev = 0;
        for (noa = 0; noa < this.m_label.length(); ++noa) {
            if (this.m_label.charAt(noa) != '\n') continue;
            this.m_lines.addElement(this.m_label.substring(prev, noa));
            prev = noa + 1;
        }
        this.m_lines.addElement(this.m_label.substring(prev, noa));
    }

    public Dimension stringSize(FontMetrics f) {
        String s;
        Dimension d = new Dimension();
        int old = 0;
        int noa = 0;
        while ((s = this.getLine(noa)) != null) {
            ++noa;
            old = f.stringWidth(s);
            if (old <= d.width) continue;
            d.width = old;
        }
        d.height = noa * f.getHeight();
        return d;
    }

    public String getLine(int n) {
        if (n < this.m_lines.size()) {
            return this.m_lines.elementAt(n);
        }
        return null;
    }

    public String getRsource() {
        return this.m_rsource;
    }

    public void setRsource(String v) {
        this.m_rsource = v;
    }

    public String getRtarget() {
        return this.m_rtarget;
    }

    public void setRtarget(String v) {
        this.m_rtarget = v;
    }

    public Node getSource() {
        return this.m_source;
    }

    public void setSource(Node v) {
        this.m_source = v;
        v.addChild(this);
    }

    public Node getTarget() {
        return this.m_target;
    }

    public void setTarget(Node v) {
        this.m_target = v;
        v.setParent(this);
    }
}

