/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.IoUtil;

public abstract class BaseJpfTask
extends MatchingTask {
    private File baseDir;
    private boolean verbose;
    private PluginRegistry registry;
    private PathResolver pathResolver;

    public final void setBaseDir(File file) {
        this.baseDir = file;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    protected final boolean getVerbose() {
        return this.verbose;
    }

    protected final PathResolver getPathResolver() {
        return this.pathResolver;
    }

    protected final PluginRegistry getRegistry() {
        return this.registry;
    }

    protected final void initRegistry(boolean bl) {
        Map map;
        Object object;
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!", this.getLocation());
        }
        if (!this.baseDir.isDirectory()) {
            throw new BuildException("basedir " + this.baseDir + " does not exist!", this.getLocation());
        }
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        this.log("Collecting manifest files...");
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.baseDir);
        this.registry = objectFactory.createRegistry();
        String[] stringArray = directoryScanner.getIncludedFiles();
        URL[] uRLArray = new URL[stringArray.length];
        HashMap<URL, URL> hashMap = new HashMap<URL, URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = new File(this.baseDir, stringArray[i]);
            try {
                uRLArray[i] = IoUtil.file2url((File)object);
                if (this.verbose) {
                    this.log("Added URL: " + uRLArray[i]);
                }
                if (!bl) continue;
                hashMap.put(uRLArray[i], IoUtil.file2url(((File)object).getParentFile()));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException("can't create URL for file " + object, (Throwable)malformedURLException, this.getLocation());
            }
        }
        try {
            map = this.registry.register(uRLArray);
        }
        catch (Exception exception) {
            throw new BuildException("can't register URLs", (Throwable)exception, this.getLocation());
        }
        this.log("... successfully registered " + map.size() + " (of " + uRLArray.length + ") manifest files ", map.size() != uRLArray.length ? 1 : 2);
        if (bl) {
            this.pathResolver = objectFactory.createPathResolver();
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                this.pathResolver.registerContext((Identity)entry.getValue(), (URL)hashMap.get(entry.getKey()));
            }
            this.log("PathResolver initialized");
        }
    }
}

