/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IfFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -7517668261071087411L;

    public String getCanonicalName() {
        return "IF";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type conditionType = parameters.getType(0);
        Object conditionValue = parameters.getValue(0);
        Boolean condition = context.getTypeRegistry().convertToLogical(conditionType, conditionValue);
        if (condition == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (Boolean.TRUE.equals(condition)) {
            Object value = parameters.getValue(1);
            Type type = parameters.getType(1);
            return new TypeValuePair(type, value);
        }
        if (parameterCount == 2 || parameters.getValue(2) == null) {
            return RETURN_FALSE;
        }
        Object value = parameters.getValue(2);
        Type type = parameters.getType(2);
        return new TypeValuePair(type, value);
    }
}

