/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.daemon.clientinput;

import java.io.Closeable;
import java.io.InputStream;
import java.util.function.Function;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.IoActions;
import org.gradle.internal.daemon.clientinput.StdInStream;
import org.gradle.internal.daemon.clientinput.StdinHandler;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.UserResponse;

public class ClientInputForwarder {
    private static final Logger LOGGER = Logging.getLogger(ClientInputForwarder.class);
    private final UserInputReader inputReader;
    private final OutputEventListener eventDispatch;

    public ClientInputForwarder(UserInputReader inputReader, OutputEventListener eventDispatch) {
        this.inputReader = inputReader;
        this.eventDispatch = eventDispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T forwardInput(Function<StdinHandler, T> action) {
        final StdInStream stdInStream = new StdInStream(new OutputEventListener(){

            public void onOutput(OutputEvent event) {
                ClientInputForwarder.this.eventDispatch.onOutput(event);
            }
        });
        this.inputReader.startInput();
        StdinHandler stdinHandler = new StdinHandler(){

            @Override
            public void onInput(ForwardInput input) {
                LOGGER.debug("Writing forwarded input on this process' stdin.");
                stdInStream.received(input.getBytes());
            }

            @Override
            public void onUserResponse(UserResponse input) {
                ClientInputForwarder.this.inputReader.putInput(new UserInputReader.TextResponse(input.getResponse()));
            }

            @Override
            public void onEndOfInput() {
                LOGGER.debug("Closing this process' stdin at end of input.");
                try {
                    stdInStream.close();
                    ClientInputForwarder.this.inputReader.putInput(UserInputReader.END_OF_INPUT);
                }
                finally {
                    LOGGER.debug("This process will no longer process any forwarded input.");
                }
            }
        };
        InputStream previousStdin = System.in;
        try {
            System.setIn(stdInStream);
            T t = action.apply(stdinHandler);
            return t;
        }
        finally {
            System.setIn(previousStdin);
            IoActions.closeQuietly((Closeable)stdInStream);
        }
    }
}

