/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client.lock;

import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import mill.main.client.lock.FileLocked;
import mill.main.client.lock.FileTryLocked;
import mill.main.client.lock.Lock;
import mill.main.client.lock.Locked;
import mill.main.client.lock.TryLocked;

class FileLock
extends Lock {
    private final RandomAccessFile raf;
    private final FileChannel chan;

    public FileLock(String string) throws Exception {
        this.raf = new RandomAccessFile(string, "rw");
        this.chan = this.raf.getChannel();
    }

    @Override
    public Locked lock() throws Exception {
        return new FileLocked(this.chan.lock());
    }

    @Override
    public TryLocked tryLock() throws Exception {
        java.nio.channels.FileLock fileLock = null;
        try {
            fileLock = this.chan.tryLock();
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            // empty catch block
        }
        return new FileTryLocked(fileLock);
    }

    @Override
    public boolean probe() throws Exception {
        java.nio.channels.FileLock fileLock = this.chan.tryLock();
        if (fileLock == null) {
            return false;
        }
        fileLock.release();
        return true;
    }

    @Override
    public void close() throws Exception {
        this.chan.close();
        this.raf.close();
    }

    @Override
    public void delete() throws Exception {
        this.close();
    }
}

